/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.BaseLockFactory;
import org.infinispan.lucene.impl.BaseLuceneLock;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.locking.LockManagerFunctionalTest")
public class LockManagerFunctionalTest
extends MultipleCacheManagersTest {
    private static final String COMMON_INDEX_NAME = "myIndex";
    private static final String ANOTHER_INDEX = "commonIndexName";
    protected Directory directory1;
    protected Directory directory2;
    protected Directory directory3;

    protected void createCacheManagers() {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createTestConfiguration(this.getTransactionsMode());
        this.createClusteredCaches(2, "lucene", configurationBuilder);
        this.directory1 = this.createDirectory(this.cache(0, "lucene"), COMMON_INDEX_NAME);
        this.directory2 = this.createDirectory(this.cache(1, "lucene"), COMMON_INDEX_NAME);
        this.directory3 = this.createDirectory(this.cache(0, "lucene"), ANOTHER_INDEX);
    }

    private Directory createDirectory(Cache lockCache, String indexName) {
        return DirectoryBuilder.newDirectoryInstance((Cache)lockCache, (Cache)lockCache, (Cache)lockCache, (String)indexName).create();
    }

    protected TransactionMode getTransactionsMode() {
        return TransactionMode.NON_TRANSACTIONAL;
    }

    @Test(dataProvider="writeLockNameProvider")
    public void testLuceneIndexLocking(String writeLockProvider) throws IOException {
        BaseLockFactory baseLockFactory = BaseLockFactory.INSTANCE;
        BaseLuceneLock luceneLockA = baseLockFactory.makeLock(this.directory1, writeLockProvider);
        BaseLuceneLock luceneLockB = baseLockFactory.makeLock(this.directory1, writeLockProvider);
        BaseLuceneLock anotherLock = baseLockFactory.makeLock(this.directory3, writeLockProvider);
        AssertJUnit.assertTrue((boolean)luceneLockA.obtain());
        AssertJUnit.assertTrue((boolean)luceneLockB.isLocked());
        AssertJUnit.assertFalse((boolean)anotherLock.isLocked());
        AssertJUnit.assertFalse((boolean)luceneLockA.obtain());
        AssertJUnit.assertFalse((boolean)luceneLockB.obtain());
        luceneLockA.close();
        AssertJUnit.assertFalse((boolean)luceneLockB.isLocked());
        AssertJUnit.assertTrue((boolean)luceneLockB.obtain());
        luceneLockA.close();
        AssertJUnit.assertFalse((boolean)luceneLockB.isLocked());
    }

    @DataProvider(name="writeLockNameProvider")
    public Object[][] provideWriteLockName() {
        return new Object[][]{{"write.lock"}, {"SomeTestLockName"}};
    }

    protected LockFactory makeLockFactory() {
        return BaseLockFactory.INSTANCE;
    }
}

