/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.h2.Driver;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.LuceneKey2StringMapper;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.lucene.testutils.TestSegmentReadLocker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DatabaseStoredIndexTest")
public class DatabaseStoredIndexTest
extends SingleCacheManagerTest {
    private static final String DB_URL = "jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=0";
    private static final String INDEX_NAME = "testing index";
    private final HashMap cacheCopy = new HashMap();
    private Connection connection;

    public DatabaseStoredIndexTest() throws SQLException {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.connection = DriverManager.getConnection(DB_URL, "sa", "");
    }

    @AfterClass(alwaysRun=true)
    public void closeDB() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            AssertJUnit.fail((String)"Could not close the keepalive DB connection");
        }
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)cb.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).preload(true)).key2StringMapper(LuceneKey2StringMapper.class).table().idColumnName("ID_COLUMN")).idColumnType("VARCHAR(255)")).tableNamePrefix("ISPN_JDBC")).dataColumnName("DATA_COLUMN")).dataColumnType("BLOB")).timestampColumnName("TIMESTAMP_COLUMN")).timestampColumnType("BIGINT")).simpleConnection().driverClass(Driver.class).connectionUrl(DB_URL).username("sa");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cb);
    }

    @Test
    public void testIndexUsage() throws IOException {
        this.cache = this.cacheManager.getCache();
        TestSegmentReadLocker testSegmentReadLocker = new TestSegmentReadLocker(this.cache, this.cache, this.cache, INDEX_NAME);
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).overrideSegmentReadLocker((SegmentReadLocker)testSegmentReadLocker).create();
        CacheTestSupport.writeTextToIndex(dir, 0, "hello database");
        CacheTestSupport.assertTextIsFoundInIds(dir, "hello", 0);
        CacheTestSupport.writeTextToIndex(dir, 1, "you have to store my index segments");
        CacheTestSupport.writeTextToIndex(dir, 2, "so that I can shut down all nodes");
        CacheTestSupport.writeTextToIndex(dir, 3, "and restart later keeping the index around");
        CacheTestSupport.assertTextIsFoundInIds(dir, "index", 1, 3);
        CacheTestSupport.removeByTerm(dir, "and");
        CacheTestSupport.assertTextIsFoundInIds(dir, "index", 1);
        dir.close();
        for (Map.Entry me : this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).entrySet()) {
            this.cacheCopy.put(me.getKey(), me.getValue());
        }
        this.cache.stop();
        this.cacheManager.stop();
    }

    @Test(dependsOnMethods={"testIndexUsage"})
    public void indexWasStored() throws IOException {
        this.cache = this.cacheManager.getCache();
        boolean failed = false;
        for (Object key : this.cacheCopy.keySet()) {
            if (key instanceof FileReadLockKey) {
                this.log.error((Object)("Key found in store, shouldn't have persisted this or should have cleaned up all readlocks on directory close:" + key));
                failed = true;
                continue;
            }
            Object expected = this.cacheCopy.get(key);
            Object actual = this.cache.get(key);
            if (expected == null && actual == null) continue;
            if (expected instanceof byte[]) {
                expected = Util.printArray((byte[])((byte[])expected), (boolean)false);
                actual = Util.printArray((byte[])((byte[])actual), (boolean)false);
            }
            if (expected != null && expected.equals(actual)) continue;
            this.log.error((Object)("Failure on key[" + key.toString() + "] expected value:\n\t" + expected + "\tactual value:\n\t" + actual));
            failed = true;
        }
        AssertJUnit.assertFalse((boolean)failed);
        AssertJUnit.assertEquals((String)"have a different number of keys", (int)this.cacheCopy.keySet().size(), (int)this.cache.keySet().size());
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).create();
        CacheTestSupport.assertTextIsFoundInIds(dir, "index", 1);
        dir.close();
    }
}

