/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.BaseLockFactory;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.locking.LockManagerFunctionalTest")
public class LockManagerFunctionalTest
extends MultipleCacheManagersTest {
    private static final String COMMON_INDEX_NAME = "myIndex";
    private static final String ANOTHER_INDEX = "commonIndexName";
    protected Directory directory1;
    protected Directory directory2;
    protected Directory directory3;

    protected void createCacheManagers() {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createTestConfiguration(this.getTransactionsMode());
        this.createClusteredCaches(2, "lucene", configurationBuilder);
        this.directory1 = this.createDirectory(this.cache(0, "lucene"), COMMON_INDEX_NAME);
        this.directory2 = this.createDirectory(this.cache(1, "lucene"), COMMON_INDEX_NAME);
        this.directory3 = this.createDirectory(this.cache(0, "lucene"), ANOTHER_INDEX);
    }

    private Directory createDirectory(Cache lockCache, String indexName) {
        return DirectoryBuilder.newDirectoryInstance((Cache)lockCache, (Cache)lockCache, (Cache)lockCache, (String)indexName).create();
    }

    protected TransactionMode getTransactionsMode() {
        return TransactionMode.NON_TRANSACTIONAL;
    }

    @Test
    public void testLuceneIndexLocking() throws IOException {
        BaseLockFactory baseLockFactory = BaseLockFactory.INSTANCE;
        AssertJUnit.assertFalse((boolean)IndexWriter.isLocked((Directory)this.directory1));
        Lock obtainedLock = this.directory1.obtainLock("write.lock");
        AssertJUnit.assertTrue((boolean)IndexWriter.isLocked((Directory)this.directory1));
        AssertJUnit.assertTrue((boolean)IndexWriter.isLocked((Directory)this.directory2));
        AssertJUnit.assertFalse((boolean)IndexWriter.isLocked((Directory)this.directory3));
        obtainedLock.ensureValid();
        obtainedLock.close();
        AssertJUnit.assertFalse((boolean)IndexWriter.isLocked((Directory)this.directory1));
        AssertJUnit.assertFalse((boolean)IndexWriter.isLocked((Directory)this.directory2));
        AssertJUnit.assertFalse((boolean)IndexWriter.isLocked((Directory)this.directory3));
    }

    protected LockFactory makeLockFactory() {
        return BaseLockFactory.INSTANCE;
    }
}

