/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.readlocks.LocalLockMergingSegmentReadLocker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.readlocks.LocalLockStressTest")
public class LocalLockStressTest
extends SingleCacheManagerTest {
    static final int NUM_THREADS = 10;
    static final int TEST_MINUTES_MAX = 10;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configurationBuilder);
    }

    @Test
    public void testMultiThreaded() {
        final Cache metadata = this.cacheManager.getCache("metadata");
        Cache chunks = this.cacheManager.getCache("chunks");
        Cache locks = this.cacheManager.getCache("locks");
        FileMetadata fileMetadata = new FileMetadata(10);
        fileMetadata.setSize(11L);
        metadata.put((Object)new FileCacheKey("indexName", "fileName"), (Object)fileMetadata);
        final LocalLockMergingSegmentReadLocker locker = new LocalLockMergingSegmentReadLocker(locks, chunks, metadata, "indexName");
        final AtomicBoolean testFailed = new AtomicBoolean(false);
        ExecutorService exec = Executors.newFixedThreadPool(10);
        Runnable stressor = new Runnable(){

            @Override
            public void run() {
                try {
                    int counter = 0;
                    while (!testFailed.get()) {
                        locker.acquireReadLock("fileName");
                        Thread.sleep(2L);
                        locker.deleteOrReleaseReadLock("fileName");
                        if (counter++ % 900 == 0) {
                            System.out.print(".");
                            Thread.sleep(7L);
                        }
                        if (metadata.get((Object)new FileCacheKey("indexName", "fileName")) != null) continue;
                        testFailed.set(true);
                        System.out.print("X");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        };
        for (int i = 0; i < 10; ++i) {
            exec.execute(stressor);
        }
        System.out.println("Stressor threads started...");
        exec.shutdown();
        try {
            exec.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            exec.shutdownNow();
        }
        AssertJUnit.assertFalse((boolean)testFailed.get());
    }
}

