/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.readlocks.DistributedSegmentReadLockerTest")
public class DistributedSegmentReadLockerTest
extends MultipleCacheManagersTest {
    protected static final String INDEX_NAME = "indexName";
    protected static final String CACHE_NAME = "lucene";
    protected static final int CHUNK_SIZE = 6;
    protected static final String filename = "readme.txt";
    protected Cache cache0;
    protected Cache cache1;
    protected Directory dirA;
    protected Directory dirB;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createTestConfiguration(TransactionMode.NON_TRANSACTIONAL);
        this.createClusteredCaches(2, CACHE_NAME, configurationBuilder);
    }

    @BeforeMethod
    protected void prepare() throws IOException {
        this.cache0 = this.cache(0, CACHE_NAME);
        this.cache1 = this.cache(1, CACHE_NAME);
        this.dirA = this.createDirectory(this.cache0);
        this.dirB = this.createDirectory(this.cache1);
        CacheTestSupport.initializeDirectory(this.dirA);
    }

    @Test
    public void testIndexWritingAndFinding() throws IOException, InterruptedException {
        this.verifyBoth(this.cache0, this.cache1);
        IndexOutput indexOutput = this.dirA.createOutput(filename, IOContext.DEFAULT);
        indexOutput.writeString("no need to write, nobody ever will read this");
        indexOutput.close();
        this.assertFileExistsHavingRLCount(filename, 1, true);
        IndexInput openInput = this.dirB.openInput(filename, IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount(filename, 2, true);
        this.dirA.deleteFile(filename);
        this.assertFileExistsHavingRLCount(filename, 1, false);
        IndexInput clone = openInput.clone();
        this.assertFileExistsHavingRLCount(filename, 1, false);
        clone.close();
        this.assertFileExistsHavingRLCount(filename, 1, false);
        openInput.close();
        this.assertFileNotExists(filename);
        this.dirA.close();
        this.dirB.close();
        this.verifyBoth(this.cache0, this.cache1);
    }

    @Test
    public void testAvoidReadLocksOnSmallFiles() throws Exception {
        CacheLockListener listener = new CacheLockListener(filename);
        this.cache0.addListener((Object)listener);
        IndexOutput indexOutput = this.dirA.createOutput(filename, IOContext.DEFAULT);
        indexOutput.writeString("a");
        indexOutput.close();
        this.dirA.deleteFile(filename);
        AssertJUnit.assertEquals((int)0, (int)listener.readLocksAcquired.intValue());
        AssertJUnit.assertEquals((int)0, (int)listener.readLocksRemoved.intValue());
    }

    void assertFileNotExists(String fileName) throws InterruptedException {
        DirectoryIntegrityCheck.assertFileNotExists(this.cache0, INDEX_NAME, fileName, 10000L);
        DirectoryIntegrityCheck.assertFileNotExists(this.cache1, INDEX_NAME, fileName, 10000L);
    }

    void assertFileExistsHavingRLCount(String fileName, int expectedReadcount, boolean expectRegisteredInFat) {
        DirectoryIntegrityCheck.assertFileExistsHavingRLCount(this.cache0, fileName, INDEX_NAME, expectedReadcount, 6, expectRegisteredInFat);
        DirectoryIntegrityCheck.assertFileExistsHavingRLCount(this.cache1, fileName, INDEX_NAME, expectedReadcount, 6, expectRegisteredInFat);
    }

    Directory createDirectory(Cache cache) {
        return DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).chunkSize(6).overrideSegmentReadLocker((SegmentReadLocker)new DistributedSegmentReadLocker(cache, cache, cache, INDEX_NAME, true)).create();
    }

    void verifyBoth(Cache cache0, Cache cache1) {
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache0, INDEX_NAME);
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache1, INDEX_NAME);
    }

    @Listener
    public static class CacheLockListener {
        LongAdder readLocksAcquired = new LongAdder();
        LongAdder readLocksRemoved = new LongAdder();
        final String fileName;

        public CacheLockListener(String fileName) {
            this.fileName = fileName;
        }

        @CacheEntryCreated
        public void entryCreated(CacheEntryEvent event) {
            if (this.validate(event)) {
                this.readLocksAcquired.increment();
            }
        }

        @CacheEntryRemoved
        public void entryRemoved(CacheEntryEvent event) {
            if (this.validate(event)) {
                this.readLocksRemoved.increment();
            }
        }

        private boolean validate(CacheEntryEvent event) {
            return !event.isPre() && event.getKey() instanceof FileReadLockKey && ((FileReadLockKey)FileReadLockKey.class.cast(event.getKey())).getFileName().equals(this.fileName);
        }
    }
}

