/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.DirectoryExtensions;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.InfinispanDirectoryTest")
public class InfinispanDirectoryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="chunkSize must be a positive integer")
    public void testInitWithInvalidChunkSize() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"index").overrideSegmentReadLocker((SegmentReadLocker)new DistributedSegmentReadLocker(cache, cache, cache, "index")).chunkSize(0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidCache() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance(null, (Cache)cache, (Cache)cache, (String)"indexName");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidChunkCache() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, null, (Cache)cache, (String)"indexName");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidIndexName() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidLockFactory() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").overrideWriteLocker(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidSegmentReadLocker() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").overrideSegmentReadLocker(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameFile() throws Exception {
        try (Directory dir = null;){
            Cache cache = this.cacheManager.getCache();
            String fileName = "testfile.txt";
            String newFileName = "newtestfile.txt";
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").create();
            this.createFile(fileName, dir);
            ((DirectoryExtensions)dir).renameFile(fileName, newFileName);
            List<String> files = Arrays.asList(dir.listAll());
            assert (!files.contains(fileName));
            assert (files.contains(newFileName));
        }
    }

    @Test
    public void testFileLength() throws IOException {
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)"indexName").create();
            AssertJUnit.assertEquals((long)0L, (long)dir.fileLength("nonExistentFile.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(String fileName, Directory dir) throws IOException {
        try (IndexOutput io = null;){
            io = dir.createOutput(fileName, IOContext.DEFAULT);
            io.writeByte((byte)66);
            io.writeByte((byte)69);
        }
    }

    private void verifyDir(Directory dir, String expectedIndexName) throws IOException {
        DirectoryExtensions infDir = (DirectoryExtensions)dir;
        AssertJUnit.assertEquals((String)expectedIndexName, (String)infDir.getIndexName());
        CacheTestSupport.writeTextToIndex(dir, 0, "hi all");
        CacheTestSupport.assertTextIsFoundInIds(dir, "hi", 0);
        CacheTestSupport.writeTextToIndex(dir, 1, "all together");
        CacheTestSupport.assertTextIsFoundInIds(dir, "all", 0, 1);
    }
}

