/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.h2.Driver;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.LuceneKey2StringMapper;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.profiling.PerformanceCompareStressTest;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.StoreStressTest", singleThreaded=true)
public class StoreStressTest
extends SingleCacheManagerTest {
    private static final String indexName = "tempIndexName";

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cb = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)cb.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).preload(true)).key2StringMapper(LuceneKey2StringMapper.class).table().idColumnName("ID_COLUMN")).idColumnType("VARCHAR(255)")).tableNamePrefix("ISPN_JDBC")).dataColumnName("DATA_COLUMN")).dataColumnType("BLOB")).timestampColumnName("TIMESTAMP_COLUMN")).timestampColumnType("BIGINT")).connectionPool().driverClass(Driver.class).connectionUrl("jdbc:h2:mem:infinispan;DB_CLOSE_DELAY=0").username("sa");
        return TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)cb);
    }

    @Test
    public void stressTestOnStore() throws InterruptedException, IOException {
        this.cache = this.cacheManager.getCache();
        assert (this.cache != null);
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)indexName).create();
        PerformanceCompareStressTest.stressTestDirectory(dir, "InfinispanClusteredWith-Store");
        DirectoryIntegrityCheck.verifyDirectoryStructure(this.cache, indexName, true);
    }
}

