/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.impl.ObtainableLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class BaseLuceneLock
extends Lock
implements Closeable,
ObtainableLock {
    private static final Log log = LogFactory.getLog(BaseLuceneLock.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Cache<Object, Object> noCacheStoreCache;
    private final String lockName;
    private final String indexName;
    private final FileCacheKey keyOfLock;

    BaseLuceneLock(Cache<?, ?> cache, String indexName, String lockName, int affinitySegmentId) {
        this.noCacheStoreCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD});
        this.lockName = lockName;
        this.indexName = indexName;
        this.keyOfLock = new FileCacheKey(indexName, lockName, affinitySegmentId);
    }

    @Override
    public boolean obtain() {
        Object previousValue = this.noCacheStoreCache.putIfAbsent((Object)this.keyOfLock, (Object)this.keyOfLock);
        if (previousValue == null) {
            if (trace) {
                log.tracef("Lock: %s acquired for index: %s", (Object)this.lockName, (Object)this.indexName);
            }
            return true;
        }
        if (trace) {
            log.tracef("Lock: %s not acquired for index: %s, was taken already.", (Object)this.lockName, (Object)this.indexName);
        }
        return false;
    }

    public void clearLock() {
        Object previousValue = this.noCacheStoreCache.remove((Object)this.keyOfLock);
        if (previousValue != null && trace) {
            log.tracef("Lock removed for index: %s", (Object)this.indexName);
        }
    }

    public boolean isLocked() {
        return this.noCacheStoreCache.containsKey((Object)this.keyOfLock);
    }

    @Override
    public void close() {
        this.clearLock();
    }

    public void ensureValid() throws IOException {
        if (!this.isLocked()) {
            throw new IOException("This lock is no longer being held");
        }
    }
}

