/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.lucene.ExternalizerIds;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.KeyVisitor;

public final class FileListCacheKey
implements IndexScopedKey {
    private final String indexName;
    private final int affinitySegmentId;
    private final int hashCode;

    public FileListCacheKey(String indexName, int affinitySegmentId) {
        this.indexName = indexName;
        this.affinitySegmentId = affinitySegmentId;
        this.hashCode = this.generatedHashCode();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public int getAffinitySegmentId() {
        return this.affinitySegmentId;
    }

    public Object accept(KeyVisitor visitor) throws Exception {
        return visitor.visit(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generatedHashCode() {
        return 31 + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileListCacheKey.class != obj.getClass()) {
            return false;
        }
        FileListCacheKey other = (FileListCacheKey)obj;
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "*|" + this.indexName + "|" + this.affinitySegmentId;
    }

    public static final class Externalizer
    extends AbstractExternalizer<FileListCacheKey> {
        public void writeObject(ObjectOutput output, FileListCacheKey key) throws IOException {
            output.writeUTF(key.indexName);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)key.affinitySegmentId);
        }

        public FileListCacheKey readObject(ObjectInput input) throws IOException {
            String indexName = input.readUTF();
            int affinitySegmentId = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            return new FileListCacheKey(indexName, affinitySegmentId);
        }

        public Integer getId() {
            return ExternalizerIds.FILE_LIST_CACHE_KEY;
        }

        public Set<Class<? extends FileListCacheKey>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{FileListCacheKey.class});
        }
    }
}

