/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.interceptors.CacheLoaderInterceptor;
import org.infinispan.lucene.cacheloader.TestHelper;
import org.infinispan.lucene.cacheloader.configuration.LuceneLoaderConfigurationBuilder;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.testutils.LuceneUtils;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cacheloader.WarmCacheTest")
public class WarmCacheTest
extends MultipleCacheManagersTest {
    public static final int CLUSTER_SIZE = 3;
    public static final String INDEX_NAME = "INDEX";
    public static final int TERMS_NUMBER = 1000;
    private File indexDir;

    @Test
    public void shouldNotHitCacheLoaderWhenWarm() throws Throwable {
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache();
        Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).create();
        AssertJUnit.assertTrue((boolean)LuceneUtils.readTerms("main", directory).contains("500"));
        AssertJUnit.assertEquals((int)1001, (int)LuceneUtils.numDocs(directory));
        LuceneUtils.collect(directory, 1000);
        this.assertNoCacheLoaderInteractions();
    }

    private void assertNoCacheLoaderInteractions() {
        for (EmbeddedCacheManager cacheManager : this.cacheManagers) {
            CacheLoaderInterceptor interceptor = (CacheLoaderInterceptor)TestingUtil.findInterceptor((Cache)cacheManager.getCache(), CacheLoaderInterceptor.class);
            AssertJUnit.assertEquals((long)0L, (long)interceptor.getCacheLoaderLoads());
            AssertJUnit.assertEquals((long)0L, (long)interceptor.getCacheLoaderMisses());
        }
    }

    protected void createCacheManagers() throws Throwable {
        this.indexDir = Files.createTempDirectory("test-", new FileAttribute[0]).toFile();
        TestHelper.createIndex(this.indexDir, INDEX_NAME, 1000, false);
        ConfigurationBuilder c = WarmCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_ASYNC, (boolean)false);
        c.clustering().hash().numOwners(1);
        c.jmxStatistics().enable();
        ((LuceneLoaderConfigurationBuilder)((LuceneLoaderConfigurationBuilder)c.persistence().addStore(LuceneLoaderConfigurationBuilder.class)).preload(true)).location(this.indexDir.getAbsolutePath());
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((File)this.indexDir);
    }
}

