/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DeltaReplicationTest")
public class DeltaReplicationTest
extends MultipleCacheManagersTest {
    private static final String INDEX_NAME = "index";

    @Test
    public void testDeltasAreSent() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)cache0, (Cache)cache0, (Cache)cache0, (String)INDEX_NAME).create();
        InboundInvocationHandlerDecorator handler0 = this.replaceOn(cache0);
        InboundInvocationHandlerDecorator handler1 = this.replaceOn(cache1);
        this.writeSingleDocument(dir);
        this.assertFileListMatch(cache0, cache1, INDEX_NAME);
        this.assertOnlyDeltasWereSent(handler0, FileListCacheKey.class);
        this.assertOnlyDeltasWereSent(handler1, FileListCacheKey.class);
    }

    private void assertOnlyDeltasWereSent(InboundInvocationHandlerDecorator handler, Class<?> clazz) {
        Set<AbstractDataWriteCommand> writeCommands = handler.writeCommands;
        for (AbstractDataWriteCommand command : writeCommands) {
            PutKeyValueCommand putKeyValueCommand;
            if (!(command instanceof PutKeyValueCommand) || !(putKeyValueCommand = (PutKeyValueCommand)command).getKey().getClass().equals(clazz)) continue;
            Object value = putKeyValueCommand.getValue();
            AssertJUnit.assertTrue((boolean)(value instanceof Delta));
        }
    }

    private void assertFileListMatch(Cache cache, Cache another, String index) {
        AssertJUnit.assertEquals((Object)this.extract(cache, index), (Object)this.extract(another, index));
    }

    private FileListCacheValue extract(Cache cache, String index) {
        DataContainer dataContainer = (DataContainer)TestingUtil.extractComponent((Cache)cache, DataContainer.class);
        InternalCacheEntry ice = dataContainer.get((Object)new FileListCacheKey(index, -1));
        return (FileListCacheValue)ice.getValue();
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = DeltaReplicationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        this.createCluster(c, 2);
        this.waitForClusterToForm();
    }

    private InboundInvocationHandlerDecorator replaceOn(Cache cache) {
        InboundInvocationHandlerDecorator decorator = new InboundInvocationHandlerDecorator((PerCacheInboundInvocationHandler)TestingUtil.extractComponent((Cache)cache, PerCacheInboundInvocationHandler.class));
        TestingUtil.replaceComponent((Cache)cache, PerCacheInboundInvocationHandler.class, (Object)decorator, (boolean)true);
        TestingUtil.replaceField((Object)decorator, (String)"inboundInvocationHandler", (Object)cache.getAdvancedCache().getComponentRegistry(), ComponentRegistry.class);
        return decorator;
    }

    private void writeSingleDocument(Directory dir) throws IOException {
        IndexWriter indexWriter = LuceneSettings.openWriter(dir, 10);
        Document document = new Document();
        document.add((IndexableField)new StringField("field", "value", Field.Store.YES));
        indexWriter.addDocument((Iterable)document);
        indexWriter.close();
    }

    class InboundInvocationHandlerDecorator
    implements PerCacheInboundInvocationHandler {
        final Set<AbstractDataWriteCommand> writeCommands = new ConcurrentHashSet();
        final PerCacheInboundInvocationHandler delegate;

        InboundInvocationHandlerDecorator(PerCacheInboundInvocationHandler delegate) {
            this.delegate = delegate;
        }

        public void handle(CacheRpcCommand cmd, Reply reply, DeliverOrder order) {
            SingleRpcCommand singleRpcCommand;
            ReplicableCommand command;
            if (cmd instanceof SingleRpcCommand && (command = (singleRpcCommand = (SingleRpcCommand)cmd).getCommand()) instanceof AbstractDataWriteCommand) {
                this.writeCommands.add((AbstractDataWriteCommand)command);
            }
            this.delegate.handle(cmd, reply, order);
        }
    }
}

