/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.lucene.impl.AddOperation;
import org.infinispan.lucene.impl.DeleteOperation;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.impl.Operation;

public class FileListCacheValueDelta
implements Delta {
    private final List<Operation> ops;

    FileListCacheValueDelta(List<Operation> ops) {
        this.ops = ops;
    }

    FileListCacheValueDelta() {
        this.ops = new ArrayList<Operation>();
    }

    public DeltaAware merge(DeltaAware deltaAware) {
        FileListCacheValue other = deltaAware instanceof FileListCacheValue ? (FileListCacheValue)deltaAware : new FileListCacheValue();
        other.apply(this.ops);
        return other;
    }

    List<Operation> getOps() {
        return this.ops;
    }

    void addOperation(String element) {
        this.ops.add(new AddOperation(element));
    }

    void removeOperation(String element) {
        AddOperation addOp = new AddOperation(element);
        if (this.ops.contains(addOp)) {
            this.ops.remove(addOp);
        } else {
            this.ops.add(new DeleteOperation(element));
        }
    }

    void discardOps() {
        this.ops.clear();
    }

    public static final class Externalizer
    extends AbstractExternalizer<FileListCacheValueDelta> {
        public Set<Class<? extends FileListCacheValueDelta>> getTypeClasses() {
            HashSet<Class<? extends FileListCacheValueDelta>> classes = new HashSet<Class<? extends FileListCacheValueDelta>>();
            classes.add(FileListCacheValueDelta.class);
            return classes;
        }

        public void writeObject(ObjectOutput output, FileListCacheValueDelta object) throws IOException {
            int size = object.ops.size();
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)size);
            for (int i = 0; i < size; ++i) {
                output.writeObject(object.ops.get(i));
            }
        }

        public FileListCacheValueDelta readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            ArrayList<Operation> operations = new ArrayList<Operation>(size);
            for (int i = 0; i < size; ++i) {
                operations.add((Operation)input.readObject());
            }
            return new FileListCacheValueDelta(operations);
        }
    }
}

