/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;

public abstract class CacheTestSupport {
    private static final Log log = LogFactory.getLog(CacheTestSupport.class);

    protected static CacheContainer createTestCacheManager() {
        return TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)CacheTestSupport.createTestConfiguration(TransactionMode.NON_TRANSACTIONAL));
    }

    public static ConfigurationBuilder createTestConfiguration(TransactionMode transactionMode) {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).remoteTimeout(10000L).stateTransfer().fetchInMemoryState(true).l1().enable().transaction().transactionMode(transactionMode).locking().lockAcquisitionTimeout(10000L).invocationBatching().disable().deadlockDetection().disable().jmxStatistics().disable();
        return builder;
    }

    public static CacheContainer createLocalCacheManager() {
        ConfigurationBuilder builder = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    public static ConfigurationBuilder createLocalCacheConfiguration() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        builder.clustering().cacheMode(CacheMode.LOCAL).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL).locking().lockAcquisitionTimeout(10000L).invocationBatching().disable().deadlockDetection().disable().jmxStatistics().disable();
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File createDummyDocToIndex(String fileName, int sz) throws Exception {
        File dummyDocToIndex = new File(fileName);
        if (dummyDocToIndex.exists()) {
            boolean deleted = dummyDocToIndex.delete();
            assert (deleted);
        }
        boolean newFileCreated = dummyDocToIndex.createNewFile();
        assert (newFileCreated);
        Random r = new Random();
        try (FileWriter fw = new FileWriter(dummyDocToIndex);){
            for (int i = 0; i < sz; ++i) {
                fw.write(Integer.toHexString(r.nextInt(16)));
            }
        }
        dummyDocToIndex.deleteOnExit();
        return dummyDocToIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doWriteOperation(Directory d, File document) throws Exception {
        IndexWriter writer = null;
        try {
            writer = LuceneSettings.openWriter(d, 2000);
            log.info((Object)"IndexWriter was constructed");
            Document doc = new Document();
            doc.add((IndexableField)new StringField("path", document.getPath(), Field.Store.YES));
            doc.add((IndexableField)new StringField("modified", DateTools.timeToString((long)document.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.YES));
            doc.add((IndexableField)new TextField("contents", (Reader)new FileReader(document)));
            doc.add((IndexableField)new TextField("info", "good", Field.Store.YES));
            writer.addDocument((Iterable)doc);
        }
        catch (LockObtainFailedException lockObtainFailedException) {
        }
        finally {
            if (writer != null) {
                writer.close();
                log.info((Object)"IndexWriter was closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doReadOperation(Directory d) throws Exception {
        DirectoryReader indexReader = null;
        IndexSearcher search = null;
        try {
            indexReader = DirectoryReader.open((Directory)d);
            search = new IndexSearcher((IndexReader)indexReader);
            Term term = new Term("path", "good");
            TermQuery termQuery = new TermQuery(term);
            search.search((Query)termQuery, 1);
        }
        finally {
            if (search != null) {
                indexReader.close();
            }
        }
    }

    public static void initializeDirectory(Directory directory) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneSettings.analyzer);
        IndexWriter iwriter = new IndexWriter(directory, indexWriterConfig);
        iwriter.commit();
        iwriter.close();
        DirectoryReader reader = DirectoryReader.open((Directory)directory);
        reader.close();
    }

    public static void removeByTerm(Directory dir, String term) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneSettings.analyzer);
        IndexWriter iw = new IndexWriter(dir, indexWriterConfig);
        iw.deleteDocuments(new Term[]{new Term("body", term)});
        iw.commit();
        iw.close();
    }

    public static void assertTextIsFoundInIds(Directory dir, String term, Integer ... validDocumentIds) throws IOException {
        int expectedResults = validDocumentIds.length;
        HashSet<Integer> expectedDocumendIds = new HashSet<Integer>(Arrays.asList(validDocumentIds));
        DirectoryReader reader = DirectoryReader.open((Directory)dir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        TermQuery query = new TermQuery(new Term("body", term));
        TopDocs docs = searcher.search((Query)query, expectedResults + 1);
        AssertJUnit.assertEquals((int)expectedResults, (int)docs.totalHits);
        for (ScoreDoc scoreDoc : docs.scoreDocs) {
            int docId = scoreDoc.doc;
            Document document = searcher.doc(docId);
            String idString = document.get("id");
            AssertJUnit.assertNotNull((Object)idString);
            Integer idFoundElement = Integer.valueOf(idString);
            assert (expectedDocumendIds.contains(idFoundElement));
        }
        reader.close();
    }

    public static void writeTextToIndex(Directory dir, int id, String text) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneSettings.analyzer);
        IndexWriter iw = new IndexWriter(dir, indexWriterConfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", String.valueOf(id), Field.Store.YES));
        doc.add((IndexableField)new TextField("body", text, Field.Store.NO));
        iw.addDocument((Iterable)doc);
        iw.commit();
        iw.close();
    }

    public static void optimizeIndex(Directory dir) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneSettings.analyzer);
        IndexWriter iw = new IndexWriter(dir, indexWriterConfig);
        iw.forceMerge(1, true);
        iw.close();
    }
}

