/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.configuration;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.configuration.NotStoreAsBinaryValidationTest")
public class NotStoreAsBinaryValidationTest
extends AbstractInfinispanTest {
    private static final String INDEX_NAME = "test-index";
    private static final String CACHE_NAME = "test-cache";
    private static final String ERROR_MESSAGE_EXP = "ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': store as binary enabled on the Cache configuration!";

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': store as binary enabled on the Cache configuration!")
    public void failOnStoreKeysAsBinary() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.storeAsBinary().enable().storeKeysAsBinary(true);
        this.failIfStoreAsBinaryEnabled(builder);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': store as binary enabled on the Cache configuration!")
    public void failOnStoreValuesAsBinary() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.storeAsBinary().enable().storeValuesAsBinary(true);
        this.failIfStoreAsBinaryEnabled(builder);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': store as binary enabled on the Cache configuration!")
    public void failOnStoreKeysAndValuesAsBinary() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.storeAsBinary().enable().storeValuesAsBinary(true).storeKeysAsBinary(true);
        this.failIfStoreAsBinaryEnabled(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void failIfStoreAsBinaryEnabled(ConfigurationBuilder configuration) {
        EmbeddedCacheManager cacheManager = null;
        try {
            cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
            cacheManager.defineConfiguration(CACHE_NAME, configuration.build());
            Cache cache = cacheManager.getCache(CACHE_NAME);
            DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).create();
            if (cacheManager == null) return;
        }
        catch (Throwable throwable) {
            if (cacheManager == null) throw throwable;
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }
}

