/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.readlocks.ConfigurationCheckTest")
public class ConfigurationCheckTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createLocalCacheConfiguration();
        configurationBuilder.eviction().strategy(EvictionStrategy.LRU).maxEntries(10L);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configurationBuilder);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testEvictionIsNotAllowed() {
        Cache c = this.cacheManager.getCache();
        new DistributedSegmentReadLocker(c, c, c, "lucene.readlocks.ConfigurationCheckTest", -1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testLocksCacheNullIsNotAllowed() {
        Cache c = this.cacheManager.getCache();
        new DistributedSegmentReadLocker(null, c, c, "lucene.readlocks.ConfigurationCheckTest", -1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testChunkCacheNullIsNotAllowed() {
        Cache c = this.cacheManager.getCache();
        new DistributedSegmentReadLocker(c, null, c, "lucene.readlocks.ConfigurationCheckTest", -1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMetaDataNullIsNotAllowed() {
        Cache c = this.cacheManager.getCache();
        new DistributedSegmentReadLocker(c, c, null, "lucene.readlocks.ConfigurationCheckTest", -1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIndexNameNullIsNotAllowed() {
        Cache c = this.cacheManager.getCache();
        new DistributedSegmentReadLocker(c, c, c, null, -1);
    }
}

