/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.configuration;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.configuration.MetadataCacheValidationTest")
public class MetadataCacheValidationTest
extends AbstractInfinispanTest {
    private static final String INDEX_NAME = "test-index";
    private static final String CACHE_NAME = "test-cache";

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Metadata Cache 'test-cache': eviction enabled on the Cache configuration!")
    public void testFailOnEviction() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.eviction().strategy(EvictionStrategy.LIRS).maxEntries(1L);
        this.doConfigurationTest(builder);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Metadata Cache 'test-cache': persistence enabled without preload on the Cache configuration!")
    public void testFailOnPersistenceWithoutPreload() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(false);
        this.doConfigurationTest(builder);
    }

    public void testSuccessfullConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true);
        builder.eviction().strategy(EvictionStrategy.NONE).maxEntries(-1L);
        this.doConfigurationTest(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doConfigurationTest(ConfigurationBuilder configuration) {
        EmbeddedCacheManager cacheManager = null;
        try {
            cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
            cacheManager.defineConfiguration(CACHE_NAME, configuration.build());
            Cache cache = cacheManager.getCache(CACHE_NAME);
            DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).create();
            if (cacheManager == null) return;
        }
        catch (Throwable throwable) {
            if (cacheManager == null) throw throwable;
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }
}

