/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.cacheloader.LuceneCacheLoader;
import org.infinispan.lucene.cacheloader.TestHelper;
import org.infinispan.lucene.cacheloader.configuration.LuceneLoaderConfigurationBuilder;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cachestore.CacheLoaderAPITest")
public class CacheLoaderAPITest
extends SingleCacheManagerTest {
    private static final String rootDirectoryName = "CacheLoaderAPITest.indexesRootDirTmp";
    private static final String indexName = "index-A";
    private static final int segmentId = 7;
    private static final int elementCount = 10;
    protected final String parentDir = TestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
    private File rootDir;

    public CacheLoaderAPITest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.rootDir = new File(new File(this.parentDir).getAbsoluteFile(), rootDirectoryName);
        boolean rootDirCreated = this.rootDir.mkdirs();
        assert (rootDirCreated) : "couldn't created root directory!";
        File subDir = new File(this.rootDir, indexName);
        boolean directoriesCreated = subDir.mkdir();
        assert (directoriesCreated) : "couldn't create directory for test";
        FSDirectory luceneDirectory = FSDirectory.open((Path)subDir.toPath());
        luceneDirectory.close();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((LuceneLoaderConfigurationBuilder)((LuceneLoaderConfigurationBuilder)builder.persistence().addStore(LuceneLoaderConfigurationBuilder.class)).preload(true)).autoChunkSize(110).location(this.rootDir.getAbsolutePath());
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    public void testFilteredKeyLoad() {
        CacheLoader loader = TestingUtil.getFirstLoader((Cache)this.cache);
        AssertJUnit.assertNotNull((Object)loader);
        AssertJUnit.assertTrue((boolean)(loader instanceof LuceneCacheLoader));
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)loader;
        PersistenceUtil.count((AdvancedCacheLoader)cacheLoader, null);
    }

    public void testLoadAllKeysWithExclusion() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        Set keyList = PersistenceUtil.toKeySet((AdvancedCacheLoader)cacheLoader, null);
        int initialCount = keyList.size();
        HashSet<FileCacheKey> exclusionSet = new HashSet<FileCacheKey>();
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName, 7);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            exclusionSet.add(key);
        }
        keyList = PersistenceUtil.toKeySet((AdvancedCacheLoader)cacheLoader, (KeyFilter)new CollectionKeyFilter(exclusionSet));
        AssertJUnit.assertEquals((int)(initialCount - fileNamesFromIndexDir.length), (int)keyList.size());
        Iterator it = keyList.iterator();
        if (it.hasNext()) assert (!(it.next() instanceof FileCacheKey));
    }

    public void testContainsKeyWithNoExistentRootDir() throws IOException {
        Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)indexName).create();
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        TestHelper.verifyOnDirectory(directory, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName, 7);
            assert (cacheLoader.contains((Object)key));
            assert (!cacheLoader.contains((Object)fileName));
        }
    }

    public void testContainsKeyCacheKeyTypes() throws Exception {
        String[] fileNamesFromIndexDir;
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        assert (cacheLoader.contains((Object)new FileListCacheKey(indexName, 7)));
        for (String fileName : fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName)) {
            assert (!cacheLoader.contains((Object)new FileReadLockKey(indexName, fileName, 7))) : "Failed for " + fileName;
            assert (cacheLoader.contains((Object)new ChunkCacheKey(indexName, fileName, 0, 1024, 7))) : "Failed for " + fileName;
        }
        assert (!cacheLoader.contains((Object)new ChunkCacheKey(indexName, "testFile.txt", 0, 1024, 7)));
    }

    public void testLoadKey() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName, 7);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            AssertJUnit.assertNull((Object)cacheLoader.load((Object)fileName));
        }
    }

    @Test(expectedExceptions={PersistenceException.class})
    public void testLoadKeyWithNonExistentFile() throws Exception {
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        FileCacheKey key = new FileCacheKey(indexName, "testKey", 7);
        AssertJUnit.assertNull((Object)cacheLoader.load((Object)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadKeyWithInnerNonReadableDir() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        File innerDir = new File(this.rootDir.getAbsoluteFile(), "index-B");
        try {
            boolean created = innerDir.mkdir();
            assert (created);
            boolean isReadoff = innerDir.setReadable(false);
            boolean isWriteoff = innerDir.setWritable(false);
            if (isReadoff && isWriteoff) {
                LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
                cacheLoader.load((Object)5);
            } else {
                this.log.info((Object)"Skipping test because it is not possible to make the directory non-readable, i.e. because the tests are run with the root user.");
            }
        }
        catch (Exception ex) {
            assert (ex instanceof PersistenceException);
        }
        finally {
            innerDir.setReadable(true);
            innerDir.setWritable(true);
        }
    }

    public void testLoadEntries() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        Set loadedEntrySet = PersistenceUtil.toEntrySet((AdvancedCacheLoader)cacheLoader, null, (InternalEntryFactory)((InternalEntryFactory)this.cache.getAdvancedCache().getComponentRegistry().getComponent(InternalEntryFactory.class)));
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName, 7);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            boolean found = false;
            for (InternalCacheEntry entry : loadedEntrySet) {
                FileCacheKey keyFromLoad = null;
                if (!(entry.getKey() instanceof FileCacheKey) || (keyFromLoad = (FileCacheKey)entry.getKey()) == null || !keyFromLoad.equals((Object)key)) continue;
                found = true;
                break;
            }
            assert (found) : "No corresponding entry found for " + key;
        }
    }

    public void testLoadAllKeys() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        Set keyList = PersistenceUtil.toKeySet((AdvancedCacheLoader)cacheLoader, null);
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName, 7);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            boolean found = false;
            for (Object keyFromList : keyList) {
                if (!(keyFromList instanceof FileCacheKey) || !keyFromList.equals(key)) continue;
                found = true;
                break;
            }
            assert (found) : "No corresponding key was found for " + key;
        }
    }

    public void testLoadAllKeysWithExclusionOfRootKey() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        Set keySet = PersistenceUtil.toKeySet((AdvancedCacheLoader)cacheLoader, null);
        int initialCount = keySet.size();
        HashSet<FileListCacheKey> exclusionSet = new HashSet<FileListCacheKey>();
        exclusionSet.add(new FileListCacheKey(indexName, 7));
        keySet = PersistenceUtil.toKeySet((AdvancedCacheLoader)cacheLoader, (KeyFilter)new CollectionKeyFilter(exclusionSet));
        String[] fileNamesArr = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        AssertJUnit.assertEquals((int)(initialCount - 1), (int)keySet.size());
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            assert (!(it.next() instanceof FileListCacheKey));
        }
    }

    public void testLoadAllKeysWithChunkExclusion() throws Exception {
        String[] fileNames;
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        HashSet<ChunkCacheKey> exclusionSet = new HashSet<ChunkCacheKey>();
        for (String fileName : fileNames = TestHelper.getFileNamesFromDir(this.rootDir, indexName)) {
            exclusionSet.add(new ChunkCacheKey(indexName, fileName, 0, 110, 7));
        }
        Set keyList = PersistenceUtil.toKeySet((AdvancedCacheLoader)cacheLoader, null);
        this.checkIfExists(keyList, exclusionSet, true, false);
        keyList = PersistenceUtil.toKeySet((AdvancedCacheLoader)cacheLoader, (KeyFilter)new CollectionKeyFilter(exclusionSet));
        this.checkIfExists(keyList, exclusionSet, false, true);
    }

    @Test
    public void testLoadAllKeysWithNullExclusion() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)this.cacheManager.getCache());
        Set keyList = PersistenceUtil.toKeySet((AdvancedCacheLoader)cacheLoader, null);
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName, 7);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            boolean found = false;
            for (Object keyFromList : keyList) {
                if (!(keyFromList instanceof FileCacheKey) || !keyFromList.equals(key)) continue;
                found = true;
                break;
            }
            assert (found) : "No corresponding key was found for " + key;
        }
    }

    protected void teardown() {
        Util.recursiveFileRemove((File)this.rootDir);
        super.teardown();
    }

    private void checkIfExists(Set result, Set exclusionSet, boolean shouldExist, boolean allShouldBeChecked) {
        boolean keyExists = false;
        for (Object obj : exclusionSet) {
            ChunkCacheKey key = (ChunkCacheKey)obj;
            boolean exists = false;
            for (Object expectedChunk : result) {
                if (!obj.equals(expectedChunk)) continue;
                exists = true;
                break;
            }
            keyExists = exists;
            if (allShouldBeChecked || !exists) continue;
            break;
        }
        AssertJUnit.assertEquals((boolean)shouldExist, (boolean)keyExists);
    }
}

