/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLockerTest;
import org.infinispan.lucene.readlocks.NoopSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.readlocks.NoopSegmentReadLockerTest")
public class NoopSegmentReadLockerTest
extends DistributedSegmentReadLockerTest {
    @Override
    Directory createDirectory(Cache cache) {
        return DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").chunkSize(6).overrideSegmentReadLocker((SegmentReadLocker)new NoopSegmentReadLocker()).create();
    }

    @Override
    @Test
    public void testIndexWritingAndFinding() throws IOException, InterruptedException {
        this.verifyIgnoringFiles(this.cache0, this.cache1, Util.asSet((Object[])new String[]{"pending_segments_1"}));
        IndexOutput indexOutput = this.dirA.createOutput("readme.txt", IOContext.DEFAULT);
        indexOutput.writeString("no need to write, nobody ever will read this");
        indexOutput.close();
        this.assertFileExistsHavingRLCount("readme.txt", 0, true);
        IndexInput firstOpenOnB = this.dirB.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 0, true);
        this.dirA.deleteFile("readme.txt");
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        IndexInput cloneOfFirstOpenOnB = firstOpenOnB.clone();
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        cloneOfFirstOpenOnB.close();
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        IndexInput firstOpenOnA = this.dirA.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        IndexInput secondOpenOnA = this.dirA.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        firstOpenOnA.close();
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        secondOpenOnA.close();
        this.assertFileExistsHavingRLCount("readme.txt", 0, false);
        firstOpenOnB.close();
        this.assertFileAfterDeletion(this.cache0);
        this.assertFileAfterDeletion(this.cache1);
        this.dirA.close();
        this.dirB.close();
        Set left_behind = Util.asSet((Object[])new String[]{"pending_segments_1", "readme.txt"});
        this.verifyIgnoringFiles(this.cache0, left_behind);
        this.verifyIgnoringFiles(this.cache1, left_behind);
    }

    void verifyIgnoringFiles(Cache cache0, Cache cache1, Set<String> files) {
        this.verifyIgnoringFiles(cache0, files);
        this.verifyIgnoringFiles(cache1, files);
    }

    void verifyIgnoringFiles(Cache cache, Set<String> ignoring) {
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache, "indexName", ignoring);
    }

    private void assertFileAfterDeletion(Cache cache) {
        FileListCacheValue fileList = (FileListCacheValue)cache.get((Object)new FileListCacheKey("indexName", -1));
        AssertJUnit.assertNotNull((Object)fileList);
        AssertJUnit.assertFalse((boolean)fileList.contains("readme.txt"));
        FileMetadata metadata = (FileMetadata)cache.get((Object)new FileCacheKey("indexName", "readme.txt", -1));
        AssertJUnit.assertNotNull((Object)metadata);
        long totalFileSize = metadata.getSize();
        int chunkNumbers = (int)(totalFileSize / 6L);
        for (int i = 0; i < chunkNumbers; ++i) {
            AssertJUnit.assertNotNull((Object)cache.get((Object)new ChunkCacheKey("indexName", "readme.txt", i, 6, -1)));
        }
        boolean fileNameExistsInCache = false;
        for (Object key : cache.keySet()) {
            FileCacheKey keyObj;
            if (!(key instanceof FileCacheKey) || !(keyObj = (FileCacheKey)key).getFileName().contains("readme.txt")) continue;
            fileNameExistsInCache = true;
        }
        AssertJUnit.assertTrue((boolean)fileNameExistsInCache);
    }
}

