/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLockerTest;
import org.infinispan.lucene.readlocks.LocalLockMergingSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.readlocks.LocalLockMergingSegmentReadLockerTest")
public class LocalLockMergingSegmentReadLockerTest
extends DistributedSegmentReadLockerTest {
    @Override
    @Test
    public void testIndexWritingAndFinding() throws IOException, InterruptedException {
        this.prepareEnvironment(false);
        this.verifyBoth(this.cache0, this.cache1);
        IndexOutput indexOutput = this.dirA.createOutput("readme.txt", IOContext.DEFAULT);
        indexOutput.writeString("no need to write, nobody ever will read this");
        indexOutput.close();
        this.assertFileExistsHavingRLCount("readme.txt", 1, true);
        IndexInput firstOpenOnB = this.dirB.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 2, true);
        this.dirA.deleteFile("readme.txt");
        this.assertFileExistsHavingRLCount("readme.txt", 1, false);
        IndexInput cloneOfFirstOpenOnB = firstOpenOnB.clone();
        this.assertFileExistsHavingRLCount("readme.txt", 1, false);
        cloneOfFirstOpenOnB.close();
        this.assertFileExistsHavingRLCount("readme.txt", 1, false);
        IndexInput firstOpenOnA = this.dirA.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 2, false);
        IndexInput secondOpenOnA = this.dirA.openInput("readme.txt", IOContext.DEFAULT);
        this.assertFileExistsHavingRLCount("readme.txt", 2, false);
        firstOpenOnA.close();
        this.assertFileExistsHavingRLCount("readme.txt", 2, false);
        secondOpenOnA.close();
        this.assertFileExistsHavingRLCount("readme.txt", 1, false);
        firstOpenOnB.close();
        this.assertFileNotExists("readme.txt");
        this.dirA.close();
        this.dirB.close();
        this.verifyBoth(this.cache0, this.cache1);
    }

    @Test
    public void testAdditionalIndexWritingAndFinding() throws IOException, InterruptedException {
        this.prepareEnvironment(true);
        this.testIndexWritingAndFinding();
    }

    @Override
    Directory createDirectory(Cache cache) {
        return DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").chunkSize(6).overrideSegmentReadLocker((SegmentReadLocker)new LocalLockMergingSegmentReadLocker(cache, "indexName", -1)).overrideSegmentReadLocker((SegmentReadLocker)new LocalLockMergingSegmentReadLocker(cache, cache, cache, "indexName", true, -1)).create();
    }

    Directory createAdditionalDirectory(Cache cache) {
        return DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").chunkSize(6).overrideSegmentReadLocker((SegmentReadLocker)new LocalLockMergingSegmentReadLocker(cache, cache, cache, "indexName", -1)).overrideSegmentReadLocker((SegmentReadLocker)new LocalLockMergingSegmentReadLocker(cache, cache, cache, "indexName", true, 1)).create();
    }

    private void prepareEnvironment(boolean useDefConstructor) throws IOException {
        this.cache0 = this.cache(0, "lucene");
        this.cache1 = this.cache(1, "lucene");
        if (useDefConstructor) {
            this.dirA = this.createDirectory(this.cache0);
            this.dirB = this.createDirectory(this.cache1);
        } else {
            this.dirA = this.createAdditionalDirectory(this.cache0);
            this.dirB = this.createAdditionalDirectory(this.cache1);
        }
        CacheTestSupport.initializeDirectory(this.dirA);
    }
}

