/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.infinispan.lucene.profiling.LuceneUserThread;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.lucene.testutils.LuceneSettings;

public class LuceneWriterExclusiveThread
extends LuceneUserThread {
    private IndexWriter iwriter;

    LuceneWriterExclusiveThread(Directory dir, SharedState state) {
        super(dir, state);
    }

    @Override
    protected void beforeLoop() throws IOException {
        this.iwriter = LuceneSettings.openWriter(this.directory, 5000);
    }

    @Override
    protected void testLoop() throws IOException {
        HashSet strings = new HashSet();
        int numElements = this.state.stringsOutOfIndex.drainTo(strings, 5);
        for (String term : strings) {
            Document doc = new Document();
            doc.add((IndexableField)new StringField("main", term, Field.Store.NO));
            this.iwriter.addDocument((Iterable)doc);
        }
        this.iwriter.commit();
        this.state.stringsInIndex.addAll(strings);
        this.state.incrementIndexWriterTaskCount(numElements);
    }

    @Override
    protected void cleanup() throws IOException {
        this.iwriter.close();
    }
}

