/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.cacheloader.IndexCacheLoaderTest;
import org.infinispan.lucene.cacheloader.LuceneCacheLoader;
import org.infinispan.lucene.cacheloader.TestHelper;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cacheloader.LuceneCacheLoaderTest")
public class LuceneCacheLoaderTest
extends IndexCacheLoaderTest {
    private static final Log log = LogFactory.getLog(LuceneCacheLoaderTest.class);
    private String indexName = "index-A";
    private int elementCount = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(expectedExceptions={CacheException.class})
    public void testLuceneCacheLoaderWithWrongDir() throws IOException {
        File file = null;
        try {
            file = new File(new File(this.parentDir).getAbsoluteFile(), "test.txt");
            boolean created = file.createNewFile();
            file.deleteOnExit();
            assert (created);
            final EmbeddedCacheManager cacheManager = this.initializeInfinispan(file);
            TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cacheManager){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void call() {
                    Directory directory = null;
                    try {
                        Cache cache = cacheManager.getCache();
                        directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)LuceneCacheLoaderTest.this.indexName).create();
                        if (directory == null) return;
                    }
                    catch (Throwable throwable) {
                        if (directory == null) throw throwable;
                        try {
                            directory.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            log.warnf((Throwable)e, "Error closing directory %s", directory);
                        }
                        throw throwable;
                    }
                    try {
                        directory.close();
                        return;
                    }
                    catch (IOException e) {
                        log.warnf((Throwable)e, "Error closing directory %s", (Object)directory);
                    }
                }
            });
            if (file == null) return;
        }
        catch (Throwable throwable) {
            if (file == null) throw throwable;
            Util.recursiveFileRemove(file);
            throw throwable;
        }
        Util.recursiveFileRemove((File)file);
    }

    public void testLuceneCacheLoaderWithNonReadableDir() throws IOException {
        boolean isReadOff = this.rootDir.setReadable(false);
        if (isReadOff) {
            final EmbeddedCacheManager cacheManager = this.initializeInfinispan(this.rootDir);
            TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cacheManager){

                public void call() {
                    try {
                        Cache cache = cacheManager.getCache();
                        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)LuceneCacheLoaderTest.this.indexName).create();
                    }
                    catch (Exception ex) {
                        assert (ex instanceof CacheException);
                    }
                    finally {
                        LuceneCacheLoaderTest.this.rootDir.setReadable(true);
                    }
                }
            });
        } else {
            log.info((Object)"Skipping test because it is not possible to make the directory non-readable, i.e. because the tests are run with the root user.");
        }
    }

    public void testContainsKeyWithNoExistentRootDir() {
        final File rootDir = new File(new File(this.parentDir).getAbsoluteFile(), this.getIndexPathName() + "___");
        final EmbeddedCacheManager cacheManager = this.initializeInfinispan(rootDir);
        try {
            TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(cacheManager){

                public void call() throws Exception {
                    Cache cache = cacheManager.getCache();
                    Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)LuceneCacheLoaderTest.this.indexName).create();
                    TestHelper.createIndex(rootDir, LuceneCacheLoaderTest.this.indexName, LuceneCacheLoaderTest.this.elementCount, true);
                    TestHelper.verifyOnDirectory(directory, LuceneCacheLoaderTest.this.elementCount, true);
                    String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(rootDir, LuceneCacheLoaderTest.this.indexName);
                    LuceneCacheLoader cacheLoader = (LuceneCacheLoader)TestingUtil.getFirstLoader((Cache)cacheManager.getCache());
                    for (String fileName : fileNamesFromIndexDir) {
                        FileCacheKey key = new FileCacheKey(LuceneCacheLoaderTest.this.indexName, fileName, -1);
                        assert (cacheLoader.contains((Object)key));
                        assert (!cacheLoader.contains((Object)fileName));
                    }
                }
            });
        }
        finally {
            Util.recursiveFileRemove((File)rootDir);
        }
    }
}

