/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.configuration;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.configuration.NoStateTransferValidationTest")
public class NoStateTransferValidationTest
extends AbstractInfinispanTest {
    private static final String INDEX_NAME = "test-index";
    private static final String CACHE_NAME = "test-cache";
    private static final String ERROR_MESSAGE_EXP = "ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': fetch in state is not enabled in Cache configuration!";

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': fetch in state is not enabled in Cache configuration!")
    public void testFailWithoutFetchAnyState() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(false);
        this.doConfigurationTest(builder);
    }

    public void testNoFailWithFetchInMemoryState() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(true);
        this.doConfigurationTest(builder);
    }

    public void testNoFailWithFetchPersistenceState() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(true)).preload(true);
        this.doConfigurationTest(builder);
    }

    public void testNoFailWithCacheLoaderAndFetchInMemoryState() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(true);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(false)).preload(true);
        this.doConfigurationTest(builder);
    }

    public void testNoFailWithSharedCacheLoader() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(false)).preload(true)).shared(true);
        this.doConfigurationTest(builder);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': fetch in state is not enabled in Cache configuration!")
    public void testNoFailWithPassivationCacheLoader() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(false)).preload(true);
        this.doConfigurationTest(builder);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': fetch in state is not enabled in Cache configuration!")
    public void testNoFailWithPassivationCacheLoader2() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(true)).preload(true);
        this.doConfigurationTest(builder);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'test-index' can not use Cache 'test-cache': fetch in state is not enabled in Cache configuration!")
    public void testNoFailWithPassivationCacheLoader3() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(true);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(false)).preload(true);
        this.doConfigurationTest(builder);
    }

    public void testNoFailWithPassivationCacheLoader4() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().fetchInMemoryState(true);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(true)).preload(true);
        this.doConfigurationTest(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doConfigurationTest(ConfigurationBuilder configuration) {
        EmbeddedCacheManager cacheManager = null;
        try {
            cacheManager = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)configuration);
            cacheManager.defineConfiguration(CACHE_NAME, configuration.build());
            Cache cache = cacheManager.getCache(CACHE_NAME);
            DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).create();
            if (cacheManager == null) return;
        }
        catch (Throwable throwable) {
            if (cacheManager == null) throw throwable;
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }
}

