/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.DirectoryLucene;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DirectoryImplementerTests")
public class DirectoryImplementerTests
extends SingleCacheManagerTest {
    private static final String INDEX_NAME = "index-A";
    private static final int BUFFER_SIZE = 1024;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="chunkSize must be a positive integer")
    public void testInitWithInvalidChunkSize() throws IOException {
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(0).create();
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailureOfOverrideWriteLocker() throws IOException {
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(1024).overrideWriteLocker(null).create();
        }
    }

    public void testOverrideWriteLocker() throws IOException {
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(1024).overrideWriteLocker(new LockFactory(){

                public Lock obtainLock(Directory dir, String lockName) throws IOException {
                    return null;
                }
            }).create();
            AssertJUnit.assertEquals((int)0, (int)dir.listAll().length);
        }
    }

    @Test
    public void testGetIndexNameAndToString() throws IOException {
        Cache cache = this.cacheManager.getCache();
        try (Directory dir = null;){
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).chunkSize(1024).create();
            AssertJUnit.assertEquals((String)INDEX_NAME, (String)((DirectoryLucene)dir).getIndexName());
            AssertJUnit.assertEquals((String)"InfinispanDirectory{indexName='index-A'}", (String)dir.toString());
        }
    }

    private void createFile(Directory directory, String name) throws IOException {
        IndexOutput indexOutput = directory.createOutput(name, IOContext.DEFAULT);
        indexOutput.writeByte((byte)0);
        indexOutput.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigureAsyncDeletes() throws Exception {
        Cache cache = this.cacheManager.getCache();
        ExecutorService executor = (ExecutorService)Mockito.spy((Object)Executors.newFixedThreadPool(1));
        try (Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).chunkSize(1024).deleteOperationsExecutor((Executor)executor).create();){
            this.createFile(directory, "file");
            Assert.assertEquals((int)directory.listAll().length, (int)1);
            directory.deleteFile("file");
            this.eventuallyEquals(0, () -> {
                try {
                    return directory.listAll().length;
                }
                catch (IOException e) {
                    Assert.fail((String)"Error inspecting directory", (Throwable)e);
                    return null;
                }
            });
            ((ExecutorService)Mockito.verify((Object)executor)).execute((Runnable)ArgumentMatchers.any(DirectoryLucene.DeleteTask.class));
        }
        finally {
            executor.shutdownNow();
        }
    }
}

