/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.lucene.impl.DirectoryBuilderImpl;
import org.infinispan.lucene.locking.TransactionalLockManagerFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.locking.TransactionalLockManagerExcFunctionalTest")
public class TransactionalLockManagerExcFunctionalTest
extends TransactionalLockManagerFunctionalTest {
    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp="Failed looking up TransactionManager: the cache is not running")
    public void testLuceneIndexLockingWithStoppedCache() throws IOException {
        String commonIndexName = "myIndex";
        Cache cache1 = this.cache(0, "lucene");
        this.cache(0, "lucene").stop();
        this.cache(1, "lucene").stop();
        TestingUtil.killCacheManagers((List)this.cacheManagers);
        LockFactory lockFactory = this.makeLockFactory();
        lockFactory.obtainLock(new DirectoryBuilderImpl(cache1, cache1, cache1, "myIndex").create(), "myLock");
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp="Failed looking up TransactionManager. Check if any transaction manager is associated with Infinispan cache: 'lucene'")
    public void testLuceneIndexLockingWithCache() throws IOException {
        String commonIndexName = "myIndex";
        Cache cache1 = this.cache(0, "lucene");
        LockFactory lockFactory = this.makeLockFactory();
        lockFactory.obtainLock(new DirectoryBuilderImpl(cache1, cache1, cache1, "myIndex").create(), "myLock");
    }

    @Override
    @Test
    public void testLuceneIndexLocking() throws IOException {
    }

    @Override
    protected TransactionMode getTransactionsMode() {
        return TransactionMode.NON_TRANSACTIONAL;
    }
}

