/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.lucene.locking.TransactionalLockManagerFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.locking.TransactionalLockManagerExcFunctionalTest", enabled=true)
public class TransactionalLockManagerExcFunctionalTest
extends TransactionalLockManagerFunctionalTest {
    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp="Failed looking up TransactionManager: the cache is not running")
    public void testLuceneIndexLockingWithStoppedCache() throws IOException {
        String commonIndexName = "myIndex";
        Cache cache1 = this.cache(0, "lucene");
        this.cache(0, "lucene").stop();
        this.cache(1, "lucene").stop();
        TestingUtil.killCacheManagers((List)this.cacheManagers);
        this.makeLockFactory(cache1, "myIndex");
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp="Failed looking up TransactionManager. Check if any transaction manager is associated with Infinispan cache: 'lucene'")
    public void testLuceneIndexLockingWithCache() throws IOException {
        String commonIndexName = "myIndex";
        Cache cache1 = this.cache(0, "lucene");
        this.makeLockFactory(cache1, "myIndex");
    }

    @Override
    @Test(dataProvider="writeLockNameProvider", enabled=false)
    public void testLuceneIndexLocking(String writeLockProvider) throws IOException {
    }

    @Override
    protected TransactionMode getTransactionsMode() {
        return TransactionMode.NON_TRANSACTIONAL;
    }
}

