/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.profiling.IndexReadingStressTest;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.lucene.testutils.LuceneSettings;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.protocols.DISCARD;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.DynamicTopologyStressTest", sequential=true)
public class DynamicTopologyStressTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(DynamicTopologyStressTest.class);
    private static final boolean KEEP_GOING = false;
    private static final boolean VISUAL_PROGRESS_FEEDBACK = false;
    private static final int SECONDS_TOTAL = 15;
    private static final int WRITES_PER_SECOND = 100;
    private static final int INITIAL_INDEX_TERMS = 2000;
    private static final String INDEX_NAME = "unstableIndex";
    private static final String FIELDNAME = "fieldname";
    private static final int READERS = 5;
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private volatile int lastWrittenTermId = 0;
    private EmbeddedCacheManager[] readers = new EmbeddedCacheManager[5];
    private DISCARD[] discardPerNode = new DISCARD[5];
    private EmbeddedCacheManager writingNode;

    protected void createCacheManagers() throws Throwable {
        Configuration defaultClusteredConfig = AbstractCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC, (boolean)false);
        defaultClusteredConfig.setInvocationBatchingEnabled(false);
        TransportFlags transportFlags = new TransportFlags().withMerge(true);
        this.writingNode = this.addClusterEnabledCacheManager(defaultClusteredConfig, transportFlags);
        for (int i = 0; i < 5; ++i) {
            this.readers[i] = this.addClusterEnabledCacheManager(defaultClusteredConfig, transportFlags);
            Cache cache = this.readers[i].getCache();
            this.discardPerNode[i] = TestingUtil.getDiscardForCache((Cache)cache);
            TestingUtil.setDelayForCache((Cache)cache, (int)1, (int)1);
            TestingUtil.blockUntilViewReceived((Cache)cache, (int)(i + 1));
        }
    }

    @Test
    void testDirectoryUnstableCluster() throws IOException {
        block4: {
            Directory masterDirectory = DirectoryBuilder.newDirectoryInstance((Cache)this.writingNode.getCache(), (Cache)this.writingNode.getCache(), (Cache)this.writingNode.getCache(), (String)INDEX_NAME).create();
            SharedState sharedIndexState = IndexReadingStressTest.fillDirectory(masterDirectory, 2000);
            ExecutorService executor = Executors.newFixedThreadPool(6);
            try {
                executor.execute(new ConstantWritingThread(masterDirectory, sharedIndexState));
                for (int i = 0; i < 5; ++i) {
                    executor.execute(new ConstantReadingThread(masterDirectory, sharedIndexState));
                }
                executor.shutdown();
                executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"unexpected interruption");
            }
        }
        assert (!this.failed.get());
    }

    private void failed(Exception e) {
        log.error((Object)e);
        this.failed.set(true);
    }

    public class ConstantReadingThread
    implements Runnable {
        private final Directory masterDirectory;

        public ConstantReadingThread(Directory masterDirectory, SharedState sharedIndexState) {
            this.masterDirectory = masterDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DynamicTopologyStressTest.this.lastWrittenTermId < 1500 && !DynamicTopologyStressTest.this.failed.get()) {
                IndexReader indexReader = null;
                try {
                    int i = DynamicTopologyStressTest.this.lastWrittenTermId;
                    indexReader = IndexReader.open((Directory)this.masterDirectory, (boolean)true);
                    IndexSearcher indexSearcher = new IndexSearcher(indexReader);
                    if (i == 0) continue;
                    String termValue = "HA" + i;
                    TermQuery query = new TermQuery(new Term(DynamicTopologyStressTest.FIELDNAME, termValue));
                    TopDocs docs = indexSearcher.search((Query)query, null, 1);
                    if (docs.totalHits != 1) {
                        DynamicTopologyStressTest.this.failed.set(true);
                        log.error((Object)("String '" + termValue + "' should exist but was not found in index"));
                    }
                    Thread.sleep(1L);
                }
                catch (IOException e) {
                    DynamicTopologyStressTest.this.failed(e);
                    return;
                }
                catch (InterruptedException e) {
                    DynamicTopologyStressTest.this.failed(e);
                    return;
                }
                finally {
                    try {
                        if (indexReader == null) continue;
                        indexReader.close();
                    }
                    catch (IOException e) {
                        DynamicTopologyStressTest.this.failed(e);
                        return;
                    }
                }
            }
        }
    }

    public class ConstantWritingThread
    implements Runnable {
        private final Directory masterDirectory;

        public ConstantWritingThread(Directory masterDirectory, SharedState sharedIndexState) {
            this.masterDirectory = masterDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DynamicTopologyStressTest.this.lastWrittenTermId < 1500 && !DynamicTopologyStressTest.this.failed.get()) {
                IndexWriter writer = null;
                try {
                    int toWrite = DynamicTopologyStressTest.this.lastWrittenTermId + 1;
                    writer = LuceneSettings.openWriter(this.masterDirectory, 3);
                    Document doc = new Document();
                    Field field = new Field(DynamicTopologyStressTest.FIELDNAME, "HA" + toWrite, Field.Store.YES, Field.Index.NOT_ANALYZED);
                    doc.add((Fieldable)field);
                    writer.addDocument(doc);
                    writer.commit();
                    DynamicTopologyStressTest.this.lastWrittenTermId = toWrite;
                    Thread.sleep(10L);
                }
                catch (IOException e) {
                    DynamicTopologyStressTest.this.failed(e);
                    return;
                }
                catch (InterruptedException e) {
                    DynamicTopologyStressTest.this.failed(e);
                    return;
                }
                finally {
                    try {
                        if (writer == null) continue;
                        writer.close();
                    }
                    catch (IOException e) {
                        DynamicTopologyStressTest.this.failed(e);
                        return;
                    }
                }
            }
        }
    }
}

