/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.util.Arrays;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.LuceneKey2StringMapper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.Key2StringMapperTest")
public class Key2StringMapperTest {
    final LuceneKey2StringMapper mapper = new LuceneKey2StringMapper();

    @Test
    public void testRegex() {
        Object[] split = LuceneKey2StringMapper.singlePipePattern.split("hello|world");
        AssertJUnit.assertTrue((boolean)Arrays.deepEquals(new String[]{"hello", "world"}, split));
    }

    @Test
    public void loadChunkCacheKey() {
        AssertJUnit.assertEquals((Object)new ChunkCacheKey("my addressbook", "sgments0.gen", 34, 16000000), (Object)this.mapper.getKeyMapping("sgments0.gen|34|16000000|my addressbook"));
    }

    @Test
    public void loadFileCacheKey() {
        AssertJUnit.assertEquals((Object)new FileCacheKey("poems and songs, 3000AC-2000DC", "filename.extension"), (Object)this.mapper.getKeyMapping("filename.extension|M|poems and songs, 3000AC-2000DC"));
    }

    @Test
    public void loadFileListCacheKey() {
        AssertJUnit.assertEquals((Object)new FileListCacheKey(""), (Object)this.mapper.getKeyMapping("*|"));
        AssertJUnit.assertEquals((Object)new FileListCacheKey("the leaves of Amazonia"), (Object)this.mapper.getKeyMapping("*|the leaves of Amazonia"));
    }

    @Test
    public void loadReadLockKey() {
        AssertJUnit.assertEquals((Object)new FileReadLockKey("poems and songs, 3000AC-2000DC", "brushed steel lock"), (Object)this.mapper.getKeyMapping("brushed steel lock|RL|poems and songs, 3000AC-2000DC"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void failureForIllegalKeys() {
        this.mapper.getKeyMapping("|*|the leaves of Amazonia");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Not supporting null keys")
    public void failureForNullKey() {
        this.mapper.getKeyMapping(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void failureForNotFullKey() {
        this.mapper.getKeyMapping("sgments0.gen|34");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void failureForWrongFileCacheKey() {
        this.mapper.getKeyMapping("filename|M|5|indexname");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void failureForWrongChunkCacheKey() {
        this.mapper.getKeyMapping("filename|5a|5|indexname");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void failureForWrongFileReadLockKey() {
        this.mapper.getKeyMapping("filename|RL|5|indexname");
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="filename must not be null")
    public void testChunkCacheKeyInitWithNllFileName() {
        new ChunkCacheKey("index-A", null, 0, 1024);
    }

    @Test
    public void testChunkCacheKeyComparison() {
        AssertJUnit.assertFalse((String)"The object should not be equals to null.", (boolean)new ChunkCacheKey("index-A", "fileName", 0, 1024).equals(null));
        AssertJUnit.assertFalse((String)"The ChunkCacheKey objects should not be equal due to different file names.", (boolean)new ChunkCacheKey("index-A", "fileName", 0, 1024).equals((Object)new ChunkCacheKey("index-A", "fileName1", 0, 1024)));
        AssertJUnit.assertEquals((String)"The ChunkCacheKey objects should be equal.", (Object)new ChunkCacheKey("index-A", "fileName", 0, 1024), (Object)new ChunkCacheKey("index-A", "fileName", 0, 1024));
    }

    public void testIsSupportedType() {
        assert (!this.mapper.isSupportedType(this.getClass()));
        assert (this.mapper.isSupportedType(ChunkCacheKey.class));
        assert (this.mapper.isSupportedType(FileCacheKey.class));
        assert (this.mapper.isSupportedType(FileListCacheKey.class));
        assert (this.mapper.isSupportedType(FileReadLockKey.class));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testReadLockKeyIndexNameNull() {
        FileReadLockKey key = new FileReadLockKey(null, "brushed steel lock");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testReadLockKeyFileNameNull() {
        FileReadLockKey key = new FileReadLockKey("poems and songs, 3000AC-2000DC", null);
    }

    public void testReadLockEqualsWithNullOrNotEqualObj() {
        FileReadLockKey key = new FileReadLockKey("poems and songs, 3000AC-2000DC", "brushed steel lock");
        assert (!key.equals(null));
        AssertJUnit.assertFalse((boolean)new FileReadLockKey("poems and songs, 3000AC-2000DC", "brushed lock").equals(this.mapper.getKeyMapping("brushed steel lock|RL|poems and songs, 3000AC-2000DC")));
    }

    @Test
    public void testFileListCacheKeyComparison() {
        AssertJUnit.assertFalse((String)"The instance of FileListCacheKey should not be equal to null.", (boolean)new FileListCacheKey("index-A").equals(null));
        AssertJUnit.assertFalse((String)"The instance of FileListCacheKey should not be equal to FileCacheKey instance.", (boolean)new FileListCacheKey("index-A").equals((Object)new FileCacheKey("index-A", "test.txt")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="filename must not be null")
    public void testFileCacheKeyInit() {
        new FileCacheKey("poems and songs, 3000AC-2000DC", null);
    }

    @Test
    public void testFileCacheKeyCompWithNull() {
        AssertJUnit.assertFalse((String)"The Instance of FileCacheKey should not be equal to null.", (boolean)new FileCacheKey("poems and songs, 3000AC-2000DC", "fileName.txt").equals(null));
    }
}

