/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.infinispan.lucene.profiling.LuceneUserThread;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.lucene.testutils.LuceneSettings;

public class LuceneWriterThread
extends LuceneUserThread {
    LuceneWriterThread(Directory dir, SharedState state) {
        super(dir, state);
    }

    @Override
    protected void testLoop() throws IOException {
        HashSet strings = new HashSet();
        int numElements = this.state.stringsOutOfIndex.drainTo(strings, 5);
        IndexWriter iwriter = LuceneSettings.openWriter(this.directory, 5000);
        for (String term : strings) {
            Document doc = new Document();
            doc.add((Fieldable)new Field("main", term, Field.Store.NO, Field.Index.NOT_ANALYZED));
            iwriter.addDocument(doc);
        }
        iwriter.commit();
        iwriter.close();
        this.state.stringsInIndex.addAll(strings);
        this.state.incrementIndexWriterTaskCount(numElements);
    }
}

