/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cachestore.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.lucene.cachestore.configuration.LuceneStoreConfiguration;

public class LuceneStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<LuceneStoreConfiguration, LuceneStoreConfigurationBuilder> {
    private int autoChunkSize = 0x1FFFFFF;
    private String location = "Infinispan-IndexStore";

    public LuceneStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    public LuceneStoreConfigurationBuilder autoChunkSize(int autoChunkSize) {
        this.autoChunkSize = autoChunkSize;
        return this;
    }

    public LuceneStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public void validate() {
    }

    public LuceneStoreConfiguration create() {
        return new LuceneStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singleton().create(), this.preload, this.shared, this.properties, this.autoChunkSize, this.location);
    }

    public Builder<?> read(LuceneStoreConfiguration template) {
        this.autoChunkSize = template.autoChunkSize();
        this.location = template.location();
        return this;
    }

    public LuceneStoreConfigurationBuilder self() {
        return this;
    }

    public String toString() {
        return "LuceneStoreConfigurationBuilder{autoChunkSize=" + this.autoChunkSize + ", " + "location=" + this.location + "}";
    }
}

