/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.impl.FileListOperations;
import org.infinispan.lucene.impl.IndexInputContext;
import org.infinispan.lucene.impl.InfinispanIndexInputV3;
import org.infinispan.lucene.impl.InfinispanIndexOutput;
import org.infinispan.lucene.impl.SingleChunkIndexInput;
import org.infinispan.lucene.locking.BaseLockFactory;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Deprecated
public class InfinispanDirectory
extends Directory {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final Log log = LogFactory.getLog(InfinispanDirectory.class);
    private final AdvancedCache<FileCacheKey, FileMetadata> metadataCache;
    private final AdvancedCache<ChunkCacheKey, Object> chunksCache;
    private final String indexName;
    private final int chunkSize;
    private final FileListOperations fileOps;
    private final SegmentReadLocker readLocks;

    public InfinispanDirectory(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, String indexName, LockFactory lf, int chunkSize, SegmentReadLocker readLocker) {
        InfinispanDirectory.checkNotNull(metadataCache, "metadataCache");
        InfinispanDirectory.checkNotNull(chunksCache, "chunksCache");
        InfinispanDirectory.checkNotNull(indexName, "indexName");
        InfinispanDirectory.checkNotNull(lf, "LockFactory");
        InfinispanDirectory.checkNotNull(readLocker, "SegmentReadLocker");
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be a positive integer");
        }
        this.metadataCache = metadataCache.getAdvancedCache();
        this.chunksCache = chunksCache.getAdvancedCache();
        this.indexName = indexName;
        this.lockFactory = lf;
        this.lockFactory.setLockPrefix(this.getLockID());
        this.chunkSize = chunkSize;
        this.fileOps = new FileListOperations(this.metadataCache, indexName);
        this.readLocks = readLocker;
    }

    public InfinispanDirectory(Cache<?, ?> cache, String indexName, int chunkSize, SegmentReadLocker readLocker) {
        this(cache, cache, indexName, InfinispanDirectory.makeDefaultLockFactory(cache, indexName), chunkSize, readLocker);
    }

    public InfinispanDirectory(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, Cache<?, ?> distLocksCache, String indexName, int chunkSize) {
        this(metadataCache, chunksCache, indexName, InfinispanDirectory.makeDefaultLockFactory(distLocksCache, indexName), chunkSize, InfinispanDirectory.makeDefaultSegmentReadLocker(metadataCache, chunksCache, distLocksCache, indexName));
    }

    public InfinispanDirectory(Cache<?, ?> cache, String indexName) {
        this(cache, cache, cache, indexName, 16384);
    }

    public InfinispanDirectory(Cache<?, ?> cache) {
        this(cache, cache, cache, "", 16384);
    }

    public String[] list() {
        this.ensureOpen();
        Set<String> filesList = this.fileOps.getFileList();
        return filesList.toArray(new String[filesList.size()]);
    }

    public boolean fileExists(String name) {
        this.ensureOpen();
        return this.fileOps.getFileList().contains(name);
    }

    public long fileModified(String name) {
        this.ensureOpen();
        FileMetadata fileMetadata = this.fileOps.getFileMetadata(name);
        if (fileMetadata == null) {
            return 0L;
        }
        return fileMetadata.getLastModified();
    }

    public void touchFile(String fileName) {
        this.ensureOpen();
        FileMetadata file = this.fileOps.getFileMetadata(fileName);
        if (file != null) {
            FileCacheKey key = new FileCacheKey(this.indexName, fileName);
            file.touch();
            this.metadataCache.put((Object)key, (Object)file);
        }
    }

    public void deleteFile(String name) {
        this.ensureOpen();
        this.fileOps.deleteFileName(name);
        this.readLocks.deleteOrReleaseReadLock(name);
        if (log.isDebugEnabled()) {
            log.debugf("Removed file: %s from index: %s", (Object)name, (Object)this.indexName);
        }
    }

    public void renameFile(String from, String to) {
        ChunkCacheKey fromChunkKey;
        Object ob;
        this.ensureOpen();
        FileCacheKey fromKey = new FileCacheKey(this.indexName, from);
        FileMetadata metadata = (FileMetadata)this.metadataCache.get((Object)fromKey);
        int bufferSize = metadata.getBufferSize();
        int i = -1;
        while ((ob = this.chunksCache.get((Object)(fromChunkKey = new ChunkCacheKey(this.indexName, from, ++i, bufferSize)))) != null) {
            ChunkCacheKey toChunkKey = new ChunkCacheKey(this.indexName, to, i, bufferSize);
            this.chunksCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)toChunkKey, ob);
        }
        this.metadataCache.put((Object)new FileCacheKey(this.indexName, to), (Object)metadata);
        this.fileOps.removeAndAdd(from, to);
        this.readLocks.deleteOrReleaseReadLock(from);
        if (log.isTraceEnabled()) {
            log.tracef("Renamed file from: %s to: %s in index %s", (Object)from, (Object)to, (Object)this.indexName);
        }
    }

    public long fileLength(String name) {
        this.ensureOpen();
        FileMetadata fileMetadata = this.fileOps.getFileMetadata(name);
        if (fileMetadata == null) {
            return 0L;
        }
        return fileMetadata.getSize();
    }

    public IndexOutput createOutput(String name) {
        FileCacheKey key = new FileCacheKey(this.indexName, name);
        return new InfinispanIndexOutput(this.metadataCache, this.chunksCache, key, this.chunkSize, this.fileOps);
    }

    public IndexInput openInput(String name) throws IOException {
        FileCacheKey fileKey = new FileCacheKey(this.indexName, name);
        FileMetadata fileMetadata = (FileMetadata)this.metadataCache.get((Object)fileKey);
        if (fileMetadata == null) {
            throw new FileNotFoundException("Error loading metadata for index file: " + fileKey);
        }
        if (fileMetadata.getSize() <= (long)fileMetadata.getBufferSize()) {
            IndexInputContext iic = new IndexInputContext(this.chunksCache, fileKey, fileMetadata, null);
            return new SingleChunkIndexInput(iic);
        }
        boolean locked = this.readLocks.acquireReadLock(name);
        if (!locked) {
            throw new FileNotFoundException("Error loading metadata for index file: " + fileKey);
        }
        IndexInputContext iic = new IndexInputContext(this.chunksCache, fileKey, fileMetadata, this.readLocks);
        return new InfinispanIndexInputV3(iic);
    }

    public void close() {
        this.isOpen = false;
    }

    public String toString() {
        return "InfinispanDirectory{indexName='" + this.indexName + "'}";
    }

    public String[] listAll() {
        return this.list();
    }

    public String getIndexName() {
        return this.indexName;
    }

    private static LockFactory makeDefaultLockFactory(Cache<?, ?> cache, String indexName) {
        InfinispanDirectory.checkNotNull(cache, "cache");
        InfinispanDirectory.checkNotNull(indexName, "indexName");
        return new BaseLockFactory(cache, indexName);
    }

    private static SegmentReadLocker makeDefaultSegmentReadLocker(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, Cache<?, ?> distLocksCache, String indexName) {
        InfinispanDirectory.checkNotNull(distLocksCache, "distLocksCache");
        InfinispanDirectory.checkNotNull(indexName, "indexName");
        return new DistributedSegmentReadLocker(distLocksCache, chunksCache, metadataCache, indexName);
    }

    private static void checkNotNull(Object v, String objectname) {
        if (v == null) {
            throw new IllegalArgumentException(objectname + " must not be null");
        }
    }
}

