/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.InfinispanDirectoryTest")
public class InfinispanDirectoryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="chunkSize must be a positive integer")
    public void testInitWithInvalidChunkSize() {
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, "index", 0, (SegmentReadLocker)new DistributedSegmentReadLocker(cache, cache, cache, "index"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidCache() {
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(null, null, "cachename", null, 10, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidChunkCache() {
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, null, "cachename", null, 10, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidIndexName() {
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, null, null, 10, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidLockFactory() {
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, "indexName", null, 10, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidSegmentReadLocker() {
        Cache cache = this.cacheManager.getCache();
        InfinispanDirectory dir = new InfinispanDirectory(cache, cache, "indexName", new LockFactory(){

            public Lock makeLock(String lockName) {
                return null;
            }

            public void clearLock(String lockName) throws IOException {
            }
        }, 10, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitWithConstructor1() throws Exception {
        InfinispanDirectory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            dir = new InfinispanDirectory(cache, "index", 10, (SegmentReadLocker)new DistributedSegmentReadLocker(cache, cache, cache, "index"));
            this.verifyDir((Directory)dir, "index");
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitWithConstructor2() throws Exception {
        InfinispanDirectory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            dir = new InfinispanDirectory(cache, "index");
            this.verifyDir((Directory)dir, "index");
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitWithConstructor3() throws Exception {
        InfinispanDirectory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            dir = new InfinispanDirectory(cache);
            this.verifyDir((Directory)dir, "");
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileModified() throws Exception {
        InfinispanDirectory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            String fileName = "dummyFileName";
            dir = new InfinispanDirectory(cache, "index");
            this.createFile(fileName, (Directory)dir);
            assert (dir.fileExists(fileName));
            assert (dir.fileModified(fileName) != 0L);
            assert (dir.fileModified("nonExistentFileName.txt") == 0L);
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTouchFile() throws Exception {
        InfinispanDirectory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            String fileName = "testfile.txt";
            dir = new InfinispanDirectory(cache, "index");
            this.createFile(fileName, (Directory)dir);
            long lastModifiedDate = dir.fileModified(fileName);
            Thread.sleep(100L);
            dir.touchFile(fileName);
            assert (lastModifiedDate != dir.fileModified(fileName));
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTouchNonExistentFile() throws Exception {
        InfinispanDirectory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            String fileName = "nonExistent.txt";
            dir = new InfinispanDirectory(cache, "index");
            long lastModifiedDate = dir.fileModified(fileName);
            Thread.sleep(100L);
            dir.touchFile(fileName);
            AssertJUnit.assertEquals((long)lastModifiedDate, (long)dir.fileModified(fileName));
        }
        finally {
            dir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameFile() throws Exception {
        InfinispanDirectory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            String fileName = "testfile.txt";
            String newFileName = "newtestfile.txt";
            dir = new InfinispanDirectory(cache, "index");
            this.createFile(fileName, (Directory)dir);
            dir.renameFile(fileName, newFileName);
            assert (!dir.fileExists(fileName));
            assert (dir.fileExists(newFileName));
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileLength() throws IOException {
        InfinispanDirectory dir = null;
        try {
            dir = new InfinispanDirectory(this.cache, "index");
            AssertJUnit.assertEquals((long)0L, (long)dir.fileLength("nonExistentFile.txt"));
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(String fileName, Directory dir) throws IOException {
        IndexOutput io = null;
        try {
            io = dir.createOutput(fileName);
            io.writeByte((byte)66);
            io.writeByte((byte)69);
        }
        finally {
            io.flush();
            io.close();
        }
    }

    private void verifyDir(Directory dir, String expectedIndexName) throws IOException {
        InfinispanDirectory infDir = (InfinispanDirectory)dir;
        AssertJUnit.assertEquals((String)expectedIndexName, (String)infDir.getIndexName());
        CacheTestSupport.writeTextToIndex(dir, 0, "hi all");
        CacheTestSupport.assertTextIsFoundInIds(dir, "hi", 0);
        CacheTestSupport.writeTextToIndex(dir, 1, "all together");
        CacheTestSupport.assertTextIsFoundInIds(dir, "all", 0, 1);
    }
}

