/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.configuration;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.configuration.NoLifespanValidationTest")
public class NoLifespanValidationTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = CacheTestSupport.createLocalCacheConfiguration();
        cfg.expiration().lifespan(10L);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'testIndexAlpha' can not use Cache '___defaultcache': maximum lifespan enabled on the Cache configuration!")
    public void failOnExpiry() {
        DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)"testIndexAlpha").create();
    }
}

