/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.testutils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;

@ThreadSafe
public class ClusteredCacheFactory {
    private final BlockingQueue<ConfigurationBuilder> requests = new SynchronousQueue<ConfigurationBuilder>();
    private final BlockingQueue<Cache> results = new SynchronousQueue<Cache>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final ConfigurationBuilder cfg;
    @GuardedBy(value="this")
    private boolean started = false;
    @GuardedBy(value="this")
    private boolean stopped = false;

    public ClusteredCacheFactory(ConfigurationBuilder cfg) {
        this.cfg = cfg;
    }

    public synchronized Cache createClusteredCache() throws InterruptedException {
        if (!this.started) {
            throw new IllegalStateException("was not started");
        }
        if (this.stopped) {
            throw new IllegalStateException("was already stopped");
        }
        this.requests.put(this.cfg);
        return this.results.take();
    }

    public Cache createClusteredCacheWaitingForNodesView(int expectedGroupSize) throws InterruptedException {
        Cache cache = this.createClusteredCache();
        TestingUtil.blockUntilViewReceived((Cache)cache, (int)expectedGroupSize, (long)10000L, (boolean)false);
        return cache;
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("was already started");
        }
        if (this.stopped) {
            throw new IllegalStateException("was already stopped");
        }
        this.started = true;
        this.executor.execute(new Worker());
    }

    public synchronized void stop() {
        if (this.stopped) {
            throw new IllegalStateException("was already stopped");
        }
        if (!this.started) {
            throw new IllegalStateException("was not started");
        }
        this.stopped = true;
        this.executor.shutdownNow();
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ConfigurationBuilder configuration = (ConfigurationBuilder)ClusteredCacheFactory.this.requests.take();
                    EmbeddedCacheManager cacheContainer = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)configuration);
                    Cache cache = cacheContainer.getCache();
                    ClusteredCacheFactory.this.results.put(cache);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

