/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.InfinispanDirectoryStressTest")
public class InfinispanDirectoryStressTest {
    public static final int THREADS_NUM = 50;
    public static final int TURNS_NUM = 300;
    private static final Log log = LogFactory.getLog(InfinispanDirectoryStressTest.class);
    private AtomicInteger writeCount = new AtomicInteger(0);

    public void testInfinispanDirectory() throws Exception {
        int OPERATIONS = 100;
        CacheContainer cacheContainer = CacheTestSupport.createTestCacheManager();
        Cache cache = cacheContainer.getCache();
        Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").create();
        CacheTestSupport.initializeDirectory(directory);
        File document = CacheTestSupport.createDummyDocToIndex("document.lucene", 10000);
        for (int i = 0; i < 100; ++i) {
            CacheTestSupport.doWriteOperation(directory, document);
            CacheTestSupport.doReadOperation(directory);
        }
        IndexReader ir = IndexReader.open((Directory)directory);
        IndexSearcher search = new IndexSearcher(ir);
        Term t = new Term("info", "good");
        TermQuery query = new TermQuery(t);
        TopDocs hits = search.search((Query)query, 1);
        search.close();
        ir.close();
        assert (100 == hits.totalHits);
        directory.close();
        cacheContainer.stop();
    }

    public void testDirectoryWithMultipleThreads() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<InfinispanDirectoryThread> threads = new ArrayList<InfinispanDirectoryThread>();
        Cache cache = CacheTestSupport.createTestCacheManager().getCache();
        Directory directory1 = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").create();
        CacheTestSupport.initializeDirectory(directory1);
        Cache cache2 = CacheTestSupport.createTestCacheManager().getCache();
        Directory directory2 = DirectoryBuilder.newDirectoryInstance((Cache)cache2, (Cache)cache2, (Cache)cache2, (String)"indexName").create();
        Thread.sleep(3000L);
        InfinispanDirectoryThread tr = new InfinispanDirectoryThread(latch, directory1, true);
        threads.add(tr);
        tr.start();
        for (int i = 0; i < 49; ++i) {
            InfinispanDirectoryThread thread = i % 2 == 0 ? new InfinispanDirectoryThread(latch, directory1, false) : new InfinispanDirectoryThread(latch, directory2, false);
            threads.add(thread);
            thread.start();
        }
        latch.countDown();
        for (InfinispanDirectoryThread thread : threads) {
            thread.join();
        }
        for (InfinispanDirectoryThread thread : threads) {
            if (thread.e == null) continue;
            throw thread.e;
        }
        IndexReader indexReader1 = IndexReader.open((Directory)directory1);
        IndexSearcher search = new IndexSearcher(indexReader1);
        Term t = new Term("info", "good");
        TermQuery query = new TermQuery(t);
        int expectedDocs = this.writeCount.get();
        TopDocs hits = search.search((Query)query, 1);
        search.close();
        indexReader1.close();
        assert (expectedDocs == hits.totalHits);
        search.close();
        directory1.close();
        directory2.close();
        cache.getCacheManager().stop();
        cache2.getCacheManager().stop();
    }

    class InfinispanDirectoryThread
    extends Thread {
        Exception e;
        CountDownLatch latch;
        File document;
        Directory dir;
        boolean isWritingThread = false;

        protected InfinispanDirectoryThread(CountDownLatch latch, Directory dir, boolean isWritingThread) throws Exception {
            this.latch = latch;
            this.dir = dir;
            this.isWritingThread = isWritingThread;
            this.document = CacheTestSupport.createDummyDocToIndex("document.lucene", 10000);
        }

        @Override
        public void run() {
            try {
                this.latch.await();
                for (int i = 0; i < 300; ++i) {
                    if (!this.isWritingThread) {
                        CacheTestSupport.doReadOperation(this.dir);
                        continue;
                    }
                    InfinispanDirectoryStressTest.this.writeCount.incrementAndGet();
                    CacheTestSupport.doWriteOperation(this.dir, this.document);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Error", (Throwable)ex);
                this.e = ex;
            }
        }
    }
}

