/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.DirectoryExtensions;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.InfinispanDirectoryTest")
public class InfinispanDirectoryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="chunkSize must be a positive integer")
    public void testInitWithInvalidChunkSize() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"index").overrideSegmentReadLocker((SegmentReadLocker)new DistributedSegmentReadLocker(cache, cache, cache, "index")).chunkSize(0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidCache() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance(null, (Cache)cache, (Cache)cache, (String)"indexName");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidChunkCache() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, null, (Cache)cache, (String)"indexName");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidIndexName() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidLockFactory() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").overrideWriteLocker(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitWithInvalidSegmentReadLocker() {
        Cache cache = this.cacheManager.getCache();
        DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").overrideSegmentReadLocker(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileModified() throws Exception {
        Directory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            String fileName = "dummyFileName";
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").create();
            this.createFile(fileName, dir);
            assert (dir.fileExists(fileName));
            assert (dir.fileModified(fileName) != 0L);
            assert (dir.fileModified("nonExistentFileName.txt") == 0L);
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTouchFile() throws Exception {
        Directory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            String fileName = "testfile.txt";
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").create();
            this.createFile(fileName, dir);
            long lastModifiedDate = dir.fileModified(fileName);
            Thread.sleep(100L);
            dir.touchFile(fileName);
            assert (lastModifiedDate != dir.fileModified(fileName));
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTouchNonExistentFile() throws Exception {
        Directory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            String fileName = "nonExistent.txt";
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").create();
            long lastModifiedDate = dir.fileModified(fileName);
            Thread.sleep(100L);
            dir.touchFile(fileName);
            AssertJUnit.assertEquals((long)lastModifiedDate, (long)dir.fileModified(fileName));
        }
        finally {
            dir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameFile() throws Exception {
        Directory dir = null;
        try {
            Cache cache = this.cacheManager.getCache();
            String fileName = "testfile.txt";
            String newFileName = "newtestfile.txt";
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"indexName").create();
            this.createFile(fileName, dir);
            ((DirectoryExtensions)dir).renameFile(fileName, newFileName);
            assert (!dir.fileExists(fileName));
            assert (dir.fileExists(newFileName));
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileLength() throws IOException {
        Directory dir = null;
        try {
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)"indexName").create();
            AssertJUnit.assertEquals((long)0L, (long)dir.fileLength("nonExistentFile.txt"));
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(String fileName, Directory dir) throws IOException {
        IndexOutput io = null;
        try {
            io = dir.createOutput(fileName);
            io.writeByte((byte)66);
            io.writeByte((byte)69);
        }
        finally {
            io.flush();
            io.close();
        }
    }

    private void verifyDir(Directory dir, String expectedIndexName) throws IOException {
        DirectoryExtensions infDir = (DirectoryExtensions)dir;
        AssertJUnit.assertEquals((String)expectedIndexName, (String)infDir.getIndexName());
        CacheTestSupport.writeTextToIndex(dir, 0, "hi all");
        CacheTestSupport.assertTextIsFoundInIds(dir, "hi", 0);
        CacheTestSupport.writeTextToIndex(dir, 1, "all together");
        CacheTestSupport.assertTextIsFoundInIds(dir, "all", 0, 1);
    }
}

