/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.executors.ExecutorAllCompletionService;
import org.infinispan.filter.KeyFilter;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.cacheloader.ContractAdaptorFactory;
import org.infinispan.lucene.cacheloader.DirectoryLoaderAdaptor;
import org.infinispan.lucene.cacheloader.InternalDirectoryContract;
import org.infinispan.lucene.cacheloader.configuration.LuceneLoaderConfiguration;
import org.infinispan.lucene.logging.Log;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.TaskContextImpl;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

@ConfiguredBy(value=LuceneLoaderConfiguration.class)
public class LuceneCacheLoader
implements AdvancedCacheLoader {
    private static final Log log = (Log)LogFactory.getLog(LuceneCacheLoader.class, Log.class);
    private final ConcurrentHashMap<String, DirectoryLoaderAdaptor> openDirectories = new ConcurrentHashMap();
    private String fileRoot;
    private File rootDirectory;
    private int autoChunkSize;
    private LuceneLoaderConfiguration configuration;
    private InitializationContext ctx;

    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        this.configuration = (LuceneLoaderConfiguration)ctx.getConfiguration();
        this.fileRoot = this.configuration.location();
        this.autoChunkSize = this.configuration.autoChunkSize();
    }

    public MarshalledEntry load(Object key) {
        if (key instanceof IndexScopedKey) {
            IndexScopedKey indexKey = (IndexScopedKey)key;
            DirectoryLoaderAdaptor directoryAdaptor = this.getDirectory(indexKey);
            Object value = directoryAdaptor.load(indexKey);
            if (value != null) {
                return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, value, null);
            }
            return null;
        }
        log.cacheLoaderIgnoringKey(key);
        return null;
    }

    public boolean contains(Object key) {
        if (key instanceof IndexScopedKey) {
            IndexScopedKey indexKey = (IndexScopedKey)key;
            DirectoryLoaderAdaptor directoryAdaptor = this.getDirectory(indexKey);
            return directoryAdaptor.containsKey(indexKey);
        }
        log.cacheLoaderIgnoringKey(key);
        return false;
    }

    public void process(final KeyFilter filter, final AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        this.scanForUnknownDirectories();
        ExecutorAllCompletionService eacs = new ExecutorAllCompletionService(executor);
        final TaskContextImpl taskContext = new TaskContextImpl();
        for (final DirectoryLoaderAdaptor dir : this.openDirectories.values()) {
            eacs.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        HashSet<MarshalledEntry> allInternalEntries = new HashSet<MarshalledEntry>();
                        dir.loadAllEntries(allInternalEntries, Integer.MAX_VALUE, LuceneCacheLoader.this.ctx.getMarshaller());
                        for (MarshalledEntry me : allInternalEntries) {
                            if (taskContext.isStopped()) break;
                            if (filter != null && !filter.accept(me.getKey())) continue;
                            task.processEntry(me, (AdvancedCacheLoader.TaskContext)taskContext);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        log.errorExecutingParallelStoreTask(e);
                        throw e;
                    }
                }
            });
        }
        eacs.waitUntilAllCompleted();
        if (eacs.isExceptionThrown()) {
            throw new PersistenceException("Execution exception!", (Throwable)eacs.getFirstException());
        }
    }

    public int size() {
        return PersistenceUtil.count((AdvancedCacheLoader)this, null);
    }

    private void scanForUnknownDirectories() {
        File[] filesInRoot;
        for (File maybeDirectory : filesInRoot = this.rootDirectory.listFiles()) {
            if (!maybeDirectory.isDirectory()) continue;
            String name = maybeDirectory.getName();
            try {
                this.getDirectory(name);
            }
            catch (PersistenceException e) {
                log.couldNotWalkDirectory(name, e);
            }
        }
    }

    public void start() {
        this.rootDirectory = new File(this.fileRoot);
        if (this.rootDirectory.exists()) {
            if (!this.rootDirectory.isDirectory() || !this.rootDirectory.canRead()) {
                throw log.rootDirectoryIsNotADirectory(this.fileRoot);
            }
        } else {
            boolean mkdirsSuccess = this.rootDirectory.mkdirs();
            if (!mkdirsSuccess) {
                throw log.unableToCreateDirectory(this.fileRoot);
            }
        }
    }

    public void stop() {
        for (Map.Entry<String, DirectoryLoaderAdaptor> entry : this.openDirectories.entrySet()) {
            DirectoryLoaderAdaptor directory = entry.getValue();
            directory.close();
        }
    }

    private DirectoryLoaderAdaptor getDirectory(IndexScopedKey indexKey) {
        String indexName = indexKey.getIndexName();
        return this.getDirectory(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryLoaderAdaptor getDirectory(String indexName) {
        DirectoryLoaderAdaptor adapter = this.openDirectories.get(indexName);
        if (adapter == null) {
            ConcurrentHashMap<String, DirectoryLoaderAdaptor> concurrentHashMap = this.openDirectories;
            synchronized (concurrentHashMap) {
                adapter = this.openDirectories.get(indexName);
                if (adapter == null) {
                    File path = new File(this.rootDirectory, indexName);
                    FSDirectory directory = this.openLuceneDirectory(path);
                    InternalDirectoryContract wrapped = ContractAdaptorFactory.wrapNativeDirectory((Directory)directory);
                    adapter = new DirectoryLoaderAdaptor(wrapped, indexName, this.autoChunkSize);
                    this.openDirectories.put(indexName, adapter);
                }
            }
        }
        return adapter;
    }

    private FSDirectory openLuceneDirectory(File path) {
        try {
            return FSDirectory.open((File)path);
        }
        catch (IOException e) {
            throw log.exceptionInCacheLoader(e);
        }
    }
}

