/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.locking.BaseLockFactory;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.locking.LockManagerFunctionalTest", enabled=true)
public class LockManagerFunctionalTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createTestConfiguration(this.getTransactionsMode());
        this.createClusteredCaches(2, "lucene", configurationBuilder);
    }

    protected TransactionMode getTransactionsMode() {
        return TransactionMode.NON_TRANSACTIONAL;
    }

    @Test(dataProvider="writeLockNameProvider")
    public void testLuceneIndexLocking(String writeLockProvider) throws IOException {
        String commonIndexName = "myIndex";
        LockFactory lockManagerA = this.makeLockFactory(this.cache(0, "lucene"), "myIndex");
        LockFactory lockManagerB = this.makeLockFactory(this.cache(1, "lucene"), "myIndex");
        LockFactory isolatedLockManager = this.makeLockFactory(this.cache(0, "lucene"), "anotherIndex");
        Lock luceneLockA = lockManagerA.makeLock(writeLockProvider);
        Lock luceneLockB = lockManagerB.makeLock(writeLockProvider);
        Lock anotherLock = isolatedLockManager.makeLock(writeLockProvider);
        assert (luceneLockA.obtain());
        assert (luceneLockB.isLocked());
        assert (!anotherLock.isLocked());
        assert (!luceneLockA.obtain());
        assert (!luceneLockB.obtain());
        luceneLockA.release();
        assert (!luceneLockB.isLocked());
        assert (luceneLockB.obtain());
        lockManagerA.clearLock(writeLockProvider);
        assert (!luceneLockB.isLocked());
    }

    @DataProvider(name="writeLockNameProvider")
    public Object[][] provideWriteLockName() {
        return new Object[][]{{"write.lock"}, {"SomeTestLockName"}};
    }

    protected LockFactory makeLockFactory(Cache cache, String commonIndexName) {
        return new BaseLockFactory(cache, commonIndexName);
    }
}

