/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.DirectoryLuceneV4;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DirectoryImplementerTests")
public class DirectoryImplementerTests
extends SingleCacheManagerTest {
    private static final String INDEX_NAME = "index-A";
    private static final int BUFFER_SIZE = 1024;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = CacheTestSupport.createLocalCacheConfiguration();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="chunkSize must be a positive integer")
    public void testInitWithInvalidChunkSize() throws IOException {
        Directory dir = null;
        try {
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(0).create();
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testFailureOfOverrideWriteLocker() throws IOException {
        Directory dir = null;
        try {
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(1024).overrideWriteLocker(null).create();
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverrideWriteLocker() throws IOException {
        Directory dir = null;
        try {
            dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)INDEX_NAME).chunkSize(1024).overrideWriteLocker(new LockFactory(){

                public Lock makeLock(String lockName) {
                    return null;
                }

                public void clearLock(String lockName) throws IOException {
                }
            }).create();
            AssertJUnit.assertEquals((int)0, (int)dir.listAll().length);
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetIndexNameAndToString() throws IOException {
        Cache cache = this.cacheManager.getCache();
        Directory dir = null;
        try {
            dir = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)INDEX_NAME).chunkSize(1024).create();
            AssertJUnit.assertEquals((String)INDEX_NAME, (String)((DirectoryLuceneV4)dir).getIndexName());
            AssertJUnit.assertEquals((String)"InfinispanDirectory{indexName='index-A'}", (String)dir.toString());
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }
}

