/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cachestore;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheLoader;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.cachestore.LuceneCacheLoader;
import org.infinispan.lucene.cachestore.TestHelper;
import org.infinispan.lucene.cachestore.configuration.LuceneCacheLoaderConfiguration;
import org.infinispan.lucene.cachestore.configuration.LuceneCacheLoaderConfigurationBuilder;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cachestore.CacheLoaderAPITest")
public class CacheLoaderAPITest
extends SingleCacheManagerTest {
    private static final String rootDirectoryName = "CacheLoaderAPITest.indexesRootDirTmp";
    private static final String indexName = "index-A";
    private static final int elementCount = 10;
    protected final String parentDir = ".";
    private File rootDir;

    public CacheLoaderAPITest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.rootDir = new File(new File(".").getAbsoluteFile(), rootDirectoryName);
        boolean rootDirCreated = this.rootDir.mkdir();
        assert (rootDirCreated) : "couldn't created root directory!";
        File subDir = new File(this.rootDir, indexName);
        boolean directoriesCreated = subDir.mkdir();
        assert (directoriesCreated) : "couldn't create directory for test";
        FSDirectory luceneDirectory = FSDirectory.open((File)subDir);
        luceneDirectory.close();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((LuceneCacheLoaderConfigurationBuilder)builder.loaders().addLoader(LuceneCacheLoaderConfigurationBuilder.class)).autoChunkSize(110).location(this.rootDir.getAbsolutePath());
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    public void testFilteredKeyLoad() throws CacheLoaderException {
        CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cache, CacheLoaderManager.class);
        CacheLoader loader = cacheLoaderManager.getCacheLoader();
        AssertJUnit.assertNotNull((Object)loader);
        AssertJUnit.assertTrue((boolean)(loader instanceof LuceneCacheLoader));
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)loader;
        cacheLoader.loadAllKeys(null);
    }

    public void testLoadAllKeysWithExclusion() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        Set keyList = cacheLoader.loadAllKeys(null);
        int initialCount = keyList.size();
        HashSet<FileCacheKey> exclusionSet = new HashSet<FileCacheKey>();
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            exclusionSet.add(key);
        }
        keyList = cacheLoader.loadAllKeys(exclusionSet);
        AssertJUnit.assertEquals((int)(initialCount - fileNamesFromIndexDir.length), (int)keyList.size());
        Iterator it = keyList.iterator();
        if (it.hasNext()) assert (!(it.next() instanceof FileCacheKey));
    }

    public void testContainsKeyWithNoExistentRootDir() throws IOException, CacheLoaderException {
        Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)indexName).create();
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        TestHelper.verifyOnDirectory(directory, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName);
            assert (cacheLoader.containsKey((Object)key));
            assert (!cacheLoader.containsKey((Object)fileName));
        }
    }

    public void testContainsKeyCacheKeyTypes() throws Exception {
        String[] fileNamesFromIndexDir;
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        assert (cacheLoader.containsKey((Object)new FileListCacheKey(indexName)));
        for (String fileName : fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName)) {
            assert (!cacheLoader.containsKey((Object)new FileReadLockKey(indexName, fileName))) : "Failed for " + fileName;
            assert (cacheLoader.containsKey((Object)new ChunkCacheKey(indexName, fileName, 0, 1024))) : "Failed for " + fileName;
        }
        assert (!cacheLoader.containsKey((Object)new ChunkCacheKey(indexName, "testFile.txt", 0, 1024)));
    }

    public void testLoadKey() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            AssertJUnit.assertNull((Object)cacheLoader.load((Object)fileName));
        }
    }

    @Test(expectedExceptions={CacheLoaderException.class})
    public void testLoadKeyWithNonExistentFile() throws Exception {
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        FileCacheKey key = new FileCacheKey(indexName, "testKey");
        AssertJUnit.assertNull((Object)cacheLoader.load((Object)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadKeyWithInnerNonReadableDir() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        File innerDir = new File(this.rootDir.getAbsoluteFile(), "index-B");
        try {
            boolean created = innerDir.mkdir();
            assert (created);
            boolean isReadoff = innerDir.setReadable(false);
            boolean isWriteoff = innerDir.setWritable(false);
            if (isReadoff && isWriteoff) {
                LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
                cacheLoader.load(5);
            } else {
                System.out.println("The test should be run in case when the dir doesn't have root permissions.");
            }
        }
        catch (Exception ex) {
            assert (ex instanceof CacheLoaderException);
        }
        finally {
            innerDir.setReadable(true);
            innerDir.setWritable(true);
        }
    }

    public void testLoad0Entries() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        Set loadedEntrySet = cacheLoader.load(0);
        assert (loadedEntrySet.isEmpty());
    }

    @Test(dataProvider="passEntriesCount")
    public void testLoadEntries(int entriesNum) throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        Set loadedEntrySet = null;
        loadedEntrySet = entriesNum > 0 ? cacheLoader.load(entriesNum) : cacheLoader.loadAll();
        if (entriesNum < 10 && entriesNum > 0) {
            AssertJUnit.assertEquals((int)entriesNum, (int)loadedEntrySet.size());
        } else {
            for (String fileName : fileNamesFromIndexDir) {
                FileCacheKey key = new FileCacheKey(indexName, fileName);
                AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
                boolean found = false;
                for (InternalCacheEntry entry : loadedEntrySet) {
                    FileCacheKey keyFromLoad = null;
                    if (!(entry.getKey() instanceof FileCacheKey) || (keyFromLoad = (FileCacheKey)entry.getKey()) == null || !keyFromLoad.equals((Object)key)) continue;
                    found = true;
                    break;
                }
                assert (found) : "No corresponding entry found for " + key;
            }
        }
    }

    public void testLoadAllKeys() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        Set keyList = cacheLoader.loadAllKeys(new HashSet());
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            boolean found = false;
            for (Object keyFromList : keyList) {
                if (!(keyFromList instanceof FileCacheKey) || !keyFromList.equals(key)) continue;
                found = true;
                break;
            }
            assert (found) : "No corresponding key was found for " + key;
        }
    }

    public void testLoadAllKeysWithExclusionOfRootKey() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        Set keySet = cacheLoader.loadAllKeys(null);
        int initialCount = keySet.size();
        HashSet<FileListCacheKey> exclusionSet = new HashSet<FileListCacheKey>();
        exclusionSet.add(new FileListCacheKey(indexName));
        keySet = cacheLoader.loadAllKeys(exclusionSet);
        String[] fileNamesArr = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        AssertJUnit.assertEquals((int)(initialCount - 1), (int)keySet.size());
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            assert (!(it.next() instanceof FileListCacheKey));
        }
    }

    public void testLoadAllKeysWithChunkExclusion() throws Exception {
        String[] fileNames;
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        HashSet<ChunkCacheKey> exclusionSet = new HashSet<ChunkCacheKey>();
        for (String fileName : fileNames = TestHelper.getFileNamesFromDir(this.rootDir, indexName)) {
            exclusionSet.add(new ChunkCacheKey(indexName, fileName, 0, 110));
        }
        Set keyList = cacheLoader.loadAllKeys(null);
        this.checkIfExists(keyList, exclusionSet, true, false);
        keyList = cacheLoader.loadAllKeys(exclusionSet);
        this.checkIfExists(keyList, exclusionSet, false, true);
    }

    @Test
    public void testLoadAllKeysWithNullExclusion() throws Exception {
        TestHelper.createIndex(this.rootDir, indexName, 10, true);
        String[] fileNamesFromIndexDir = TestHelper.getFileNamesFromDir(this.rootDir, indexName);
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        Set keyList = cacheLoader.loadAllKeys(null);
        for (String fileName : fileNamesFromIndexDir) {
            FileCacheKey key = new FileCacheKey(indexName, fileName);
            AssertJUnit.assertNotNull((Object)cacheLoader.load((Object)key));
            boolean found = false;
            for (Object keyFromList : keyList) {
                if (!(keyFromList instanceof FileCacheKey) || !keyFromList.equals(key)) continue;
                found = true;
                break;
            }
            assert (found) : "No corresponding key was found for " + key;
        }
    }

    public void testGetConfigurationClass() {
        LuceneCacheLoader cacheLoader = (LuceneCacheLoader)((CacheLoaderManager)TestingUtil.extractComponent((Cache)this.cacheManager.getCache(), CacheLoaderManager.class)).getCacheLoader();
        AssertJUnit.assertSame(cacheLoader.getConfiguration().getClass(), LuceneCacheLoaderConfiguration.class);
    }

    @DataProvider(name="passEntriesCount")
    public Object[][] provideEntriesCount() {
        return new Object[][]{{new Integer(15)}, {new Integer(5)}, {new Integer(0)}};
    }

    protected void teardown() {
        TestingUtil.recursiveFileRemove((File)this.rootDir);
        super.teardown();
    }

    private void checkIfExists(Set result, Set exclusionSet, boolean shouldExist, boolean allShouldBeChecked) {
        boolean keyExists = false;
        for (Object obj : exclusionSet) {
            ChunkCacheKey key = (ChunkCacheKey)obj;
            boolean exists = false;
            for (Object expectedChunk : result) {
                if (!obj.equals(expectedChunk)) continue;
                exists = true;
                break;
            }
            keyExists = exists;
            if (allShouldBeChecked || !exists) continue;
            break;
        }
        AssertJUnit.assertEquals((boolean)shouldExist, (boolean)keyExists);
    }
}

