/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.infinispan.lucene.profiling.LuceneUserThread;
import org.infinispan.lucene.profiling.SharedState;

public class LuceneReaderThread
extends LuceneUserThread {
    protected IndexSearcher searcher;
    protected DirectoryReader indexReader;

    LuceneReaderThread(Directory dir, SharedState state) {
        super(dir, state);
    }

    @Override
    protected void testLoop() throws IOException {
        HashSet strings = new HashSet();
        int numElements = this.state.stringsInIndex.drainTo(strings, 50);
        this.refreshIndexReader();
        for (String term : strings) {
            TermQuery query = new TermQuery(new Term("main", term));
            TopDocs docs = this.searcher.search((Query)query, null, 1);
            if (docs.totalHits == 1) continue;
            throw new RuntimeException("String '" + term + "' should exist but was not found in index");
        }
        this.state.stringsInIndex.addAll(strings);
        this.state.incrementIndexSearchesCount(numElements);
    }

    protected void refreshIndexReader() throws CorruptIndexException, IOException {
        if (this.indexReader == null) {
            this.indexReader = DirectoryReader.open((Directory)this.directory);
        } else {
            DirectoryReader before = this.indexReader;
            DirectoryReader after = DirectoryReader.openIfChanged((DirectoryReader)this.indexReader);
            if (after != null) {
                before.close();
                this.indexReader = after;
            }
        }
        this.searcher = new IndexSearcher((IndexReader)this.indexReader);
    }

    @Override
    protected void cleanup() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
        }
    }
}

