/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cacheloader;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.cacheloader.DirectoryLoaderAdaptor;
import org.infinispan.lucene.cacheloader.InternalDirectoryContract;
import org.infinispan.persistence.spi.PersistenceException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.cachestore.LargeIndexesTest")
public class LargeIndexesTest {
    private static final String INDEX_NAME = "myIndex";
    private static final String FILE_NAME = "largeFile";
    private static final long TEST_SIZE = 0x80000009L;
    private static final int AUTO_BUFFER = 16;

    public void testAutoChunkingOnLargeFiles() throws PersistenceException {
        FileCacheKey k = new FileCacheKey(INDEX_NAME, FILE_NAME);
        DirectoryLoaderAdaptor adaptor = new DirectoryLoaderAdaptor((InternalDirectoryContract)new InternalDirectoryContractImpl(), INDEX_NAME, 16);
        Object loaded = adaptor.load((IndexScopedKey)k);
        AssertJUnit.assertTrue((boolean)(loaded instanceof FileMetadata));
        FileMetadata metadata = (FileMetadata)loaded;
        AssertJUnit.assertEquals((long)23L, (long)metadata.getLastModified());
        AssertJUnit.assertEquals((long)0x80000009L, (long)metadata.getSize());
        AssertJUnit.assertEquals((int)16, (int)metadata.getBufferSize());
    }

    public void testSmallChunkLoading() throws PersistenceException {
        DirectoryLoaderAdaptor adaptor = new DirectoryLoaderAdaptor((InternalDirectoryContract)new InternalDirectoryContractImpl(), INDEX_NAME, 16);
        Object loaded = adaptor.load((IndexScopedKey)new ChunkCacheKey(INDEX_NAME, FILE_NAME, 0, 16));
        AssertJUnit.assertTrue((boolean)(loaded instanceof byte[]));
        AssertJUnit.assertEquals((int)16, (int)((byte[])loaded).length);
        loaded = adaptor.load((IndexScopedKey)new ChunkCacheKey(INDEX_NAME, FILE_NAME, 5, 16));
        AssertJUnit.assertTrue((boolean)(loaded instanceof byte[]));
        AssertJUnit.assertEquals((int)16, (int)((byte[])loaded).length);
        int lastChunk = 0x8000000;
        long lastChunkSize = 9L;
        AssertJUnit.assertEquals((long)9L, (long)9L);
        loaded = adaptor.load((IndexScopedKey)new ChunkCacheKey(INDEX_NAME, FILE_NAME, 0x8000000, 16));
        AssertJUnit.assertTrue((boolean)(loaded instanceof byte[]));
        AssertJUnit.assertEquals((long)9L, (long)((byte[])loaded).length);
    }

    private static class IndexInputMock
    extends IndexInput {
        private boolean closed = false;
        private long position = 0L;

        protected IndexInputMock(String resourceDescription) {
            super(resourceDescription);
        }

        public void close() throws IOException {
            AssertJUnit.assertFalse((boolean)this.closed);
            this.closed = true;
        }

        public long getFilePointer() {
            AssertJUnit.fail((String)"should not be invoked");
            return 0L;
        }

        public void seek(long pos) throws IOException {
            this.position = pos;
        }

        public long length() {
            return 0x80000009L;
        }

        public byte readByte() throws IOException {
            return 0;
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            long remainingFileSize = 0x80000009L - this.position;
            long expectedReadSize = Math.min(remainingFileSize, 16L);
            AssertJUnit.assertEquals((long)expectedReadSize, (long)b.length);
            AssertJUnit.assertEquals((int)0, (int)offset);
            AssertJUnit.assertEquals((long)expectedReadSize, (long)len);
        }
    }

    private static class InternalDirectoryContractImpl
    implements InternalDirectoryContract {
        private InternalDirectoryContractImpl() {
        }

        public String[] listAll() throws IOException {
            AssertJUnit.fail((String)"should not be invoked");
            return null;
        }

        public long fileLength(String fileName) throws IOException {
            AssertJUnit.assertEquals((String)LargeIndexesTest.FILE_NAME, (String)fileName);
            return 0x80000009L;
        }

        public void close() throws IOException {
        }

        public long fileModified(String fileName) {
            AssertJUnit.assertEquals((String)LargeIndexesTest.FILE_NAME, (String)fileName);
            return 23L;
        }

        public IndexInput openInput(String fileName) {
            AssertJUnit.assertEquals((String)LargeIndexesTest.FILE_NAME, (String)fileName);
            return new IndexInputMock(fileName);
        }

        public boolean fileExists(String fileName) {
            AssertJUnit.fail((String)"should not be invoked");
            return false;
        }
    }
}

