/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.profiling;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.profiling.LuceneReaderThread;
import org.infinispan.lucene.profiling.LuceneWriterThread;
import org.infinispan.lucene.profiling.SharedState;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="lucene.profiling.PerformanceCompareStressTest", sequential=true)
public class PerformanceCompareStressTest {
    private static final int DICTIONARY_SIZE = 800000;
    private static final int READER_THREADS = 5;
    private static final int WRITER_THREADS = 1;
    private static final int CHUNK_SIZE = 524288;
    private static final String indexName = "tempIndexName";
    private long durationMs = 120000L;
    private Cache cache;
    private EmbeddedCacheManager cacheFactory;
    private Properties results = null;
    private String currentMethod = null;

    @Test
    public void profileTestRAMDirectory() throws InterruptedException, IOException {
        RAMDirectory dir = new RAMDirectory();
        this.stressTestDirectoryInternal((Directory)dir, "RAMDirectory");
    }

    @Test
    public void profileTestFSDirectory() throws InterruptedException, IOException {
        File indexDir = new File(TestingUtil.tmpDirectory(this.getClass()), indexName);
        boolean directoriesCreated = indexDir.mkdirs();
        assert (directoriesCreated) : "couldn't create directory for FSDirectory test";
        FSDirectory dir = FSDirectory.open((File)indexDir);
        this.stressTestDirectoryInternal((Directory)dir, "FSDirectory");
    }

    @Test
    public void profileTestInfinispanDirectoryWithNetworkDelayZero() throws InterruptedException, IOException {
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)indexName).chunkSize(524288).create();
        this.stressTestDirectoryInternal(dir, "InfinispanClustered-delayedIO:0");
        this.verifyDirectoryState();
    }

    @Test
    public void profileTestInfinispanDirectoryWithNetworkDelay4() throws Exception {
        TestingUtil.setDelayForCache((Cache)this.cache, (int)4, (int)4);
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)indexName).chunkSize(524288).create();
        this.stressTestDirectoryInternal(dir, "InfinispanClustered-delayedIO:4");
        this.verifyDirectoryState();
    }

    @Test
    public void profileTestInfinispanDirectoryWithHighNetworkDelay40() throws Exception {
        TestingUtil.setDelayForCache((Cache)this.cache, (int)40, (int)40);
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)indexName).chunkSize(524288).create();
        this.stressTestDirectoryInternal(dir, "InfinispanClustered-delayedIO:40");
        this.verifyDirectoryState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void profileInfinispanLocalDirectory() throws InterruptedException, IOException {
        CacheContainer cacheContainer = CacheTestSupport.createLocalCacheManager();
        try {
            this.cache = cacheContainer.getCache();
            Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)indexName).chunkSize(524288).create();
            this.stressTestDirectoryInternal(dir, "InfinispanLocal");
            this.verifyDirectoryState();
        }
        finally {
            cacheContainer.stop();
        }
    }

    @Test(enabled=false)
    public static void stressTestDirectory(Directory dir, String testLabel) throws InterruptedException, IOException {
        PerformanceCompareStressTest.stressTestDirectory(dir, testLabel, 120000L, null, null);
    }

    private void stressTestDirectoryInternal(Directory dir, String testLabel) throws InterruptedException, IOException {
        PerformanceCompareStressTest.stressTestDirectory(dir, testLabel, this.durationMs, this.results, this.currentMethod);
    }

    @Test(enabled=false)
    private static void stressTestDirectory(Directory dir, String testLabel, long durationMs, Properties results, String currentMethod) throws InterruptedException, IOException {
        int i;
        SharedState state = new SharedState(800000);
        CacheTestSupport.initializeDirectory(dir);
        ExecutorService e = Executors.newFixedThreadPool(6);
        for (i = 0; i < 5; ++i) {
            e.execute(new LuceneReaderThread(dir, state));
        }
        for (i = 0; i < 1; ++i) {
            e.execute(new LuceneWriterThread(dir, state));
        }
        e.shutdown();
        state.startWaitingThreads();
        Thread.sleep(durationMs);
        long searchesCount = state.incrementIndexSearchesCount(0L);
        long writerTaskCount = state.incrementIndexWriterTaskCount(0L);
        state.quit();
        boolean terminatedCorrectly = e.awaitTermination(20L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((boolean)terminatedCorrectly);
        System.out.println("Test " + testLabel + " run in " + durationMs + "ms:\n\tSearches: " + searchesCount + "\n\t" + "Writes: " + writerTaskCount);
        if (results != null) {
            results.setProperty(currentMethod + ".label", testLabel);
            results.setProperty(currentMethod + ".searches", Long.toString(searchesCount));
            results.setProperty(currentMethod + ".writes", Long.toString(writerTaskCount));
        }
    }

    @BeforeMethod
    public void beforeTest() {
        this.cacheFactory = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)CacheTestSupport.createTestConfiguration(TransactionMode.NON_TRANSACTIONAL));
        this.cacheFactory.start();
        this.cache = this.cacheFactory.getCache();
        this.cache.clear();
    }

    @AfterMethod
    public void afterTest() {
        TestingUtil.killCaches((Cache[])new Cache[]{this.cache});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheFactory});
        TestingUtil.recursiveFileRemove((String)indexName);
    }

    private void verifyDirectoryState() {
        DirectoryIntegrityCheck.verifyDirectoryStructure(this.cache, indexName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String[] testMethods = System.getProperty("lucene.profiling.tests", "profileTestRAMDirectory,profileTestFSDirectory,profileInfinispanLocalDirectory,profileTestInfinispanDirectoryWithNetworkDelayZero").split(",");
        PerformanceCompareStressTest test = new PerformanceCompareStressTest();
        test.durationMs = new Long(System.getProperty("lucene.profiling.duration", "120000"));
        String outputFile = System.getProperty("lucene.profiling.output");
        test.results = outputFile == null ? null : new Properties();
        for (String testMethod : testMethods) {
            try {
                test.currentMethod = testMethod;
                Method m = PerformanceCompareStressTest.class.getMethod(testMethod, new Class[0]);
                test.beforeTest();
                try {
                    m.invoke((Object)test, new Object[0]);
                }
                finally {
                    test.afterTest();
                }
            }
            catch (NoSuchMethodException e) {
                System.out.println("Couldn't find method " + testMethod);
                System.exit(1);
            }
        }
        if (test.results != null && !test.results.isEmpty()) {
            System.out.println("Writing results to " + outputFile + " ...");
            TestingUtil.outputPropertiesToXML((String)outputFile, (Properties)test.results);
        }
    }
}

