/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.testutils;

import org.infinispan.lucene.testutils.RepeatableLongByteSequence;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="lucene.testutils.RepeatableLongByteSequenceTest")
public class RepeatableLongByteSequenceTest {
    @Test(description="To verify the RepeatableLongByteSequence meets the requirement of producing always the same values when using the single nextByte()")
    public void verifyRepeatability() {
        RepeatableLongByteSequence src1 = new RepeatableLongByteSequence();
        RepeatableLongByteSequence src2 = new RepeatableLongByteSequence();
        for (int i = 0; i < 1000; ++i) {
            assert (src1.nextByte() == src2.nextByte());
        }
    }

    @Test(description="To verify the RepeatableLongByteSequence meets the requirement of producing always the same values when using the multivalued nextBytes()")
    public void verifyEquality() {
        RepeatableLongByteSequence src1 = new RepeatableLongByteSequence();
        RepeatableLongByteSequence src2 = new RepeatableLongByteSequence();
        int arrayLength = 10;
        byte[] b = new byte[10];
        for (int i = 0; i < 1000; ++i) {
            if (i % 10 == 0) {
                src1.nextBytes(b);
            }
            assert (b[i % 10] == src2.nextByte());
        }
    }
}

