/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.testutils;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class LuceneSettings {
    public static final Version LUCENE_VERSION = Version.LUCENE_36;
    public static final Analyzer analyzer = new SimpleAnalyzer(LUCENE_VERSION);
    private static final MergeScheduler mergeScheduler = new SerialMergeScheduler();

    private LuceneSettings() {
    }

    public static IndexWriter openWriter(Directory directory, int maxMergeDocs, boolean useSerialMerger) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LUCENE_VERSION, analyzer);
        if (useSerialMerger) {
            indexWriterConfig.setMergeScheduler(mergeScheduler);
        }
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setMaxMergeDocs(maxMergeDocs);
        indexWriterConfig.setMergePolicy((MergePolicy)mergePolicy);
        return new IndexWriter(directory, indexWriterConfig);
    }

    public static IndexWriter openWriter(Directory directory, int maxMergeDocs) throws IOException {
        return LuceneSettings.openWriter(directory, maxMergeDocs, false);
    }
}

