/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshaller.test;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.it.compatibility.EmbeddedRestMemcachedHotRodTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractCompatibilityTest
extends EmbeddedRestMemcachedHotRodTest {
    @AfterClass
    protected void teardown() {
        CompatibilityCacheFactory.killCacheFactories((CompatibilityCacheFactory[])new CompatibilityCacheFactory[]{this.cacheFactory});
    }

    protected abstract Class<? extends Encoder> getEncoderClass();

    @Test
    public void testRestPutEmbeddedMemcachedHotRodGetTest() throws Exception {
        String key = "3";
        String value = "<hey>ho</hey>";
        Marshaller marshaller = this.cacheFactory.getMarshaller();
        byte[] bytes = marshaller.objectToByteBuffer((Object)value);
        PutMethod put = new PutMethod(this.cacheFactory.getRestUrl() + "/" + "3");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(bytes, "application/octet-stream"));
        HttpClient restClient = this.cacheFactory.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        AssertJUnit.assertEquals((String)"", (String)put.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((Object)value, (Object)this.cacheFactory.getEmbeddedCache().getAdvancedCache().withEncoding(IdentityEncoder.class, this.getEncoderClass()).get((Object)"3"));
        bytes = (byte[])this.cacheFactory.getMemcachedClient().get("3");
        AssertJUnit.assertEquals((Object)value, (Object)marshaller.objectFromByteBuffer(bytes));
        bytes = (byte[])this.cacheFactory.getHotRodCache().get((Object)"3");
        AssertJUnit.assertEquals((Object)value, (Object)marshaller.objectFromByteBuffer(bytes));
    }
}

