/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshaller.test;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.it.endpoints.EmbeddedRestMemcachedHotRodTest;
import org.infinispan.it.endpoints.EndpointsCacheFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractInteropTest
extends EmbeddedRestMemcachedHotRodTest {
    @AfterClass
    protected void teardown() {
        EndpointsCacheFactory.killCacheFactories((EndpointsCacheFactory[])new EndpointsCacheFactory[]{this.cacheFactory});
    }

    @Test
    public void testRestPutEmbeddedMemcachedHotRodGetTest() throws Exception {
        String key = "3";
        String value = "<hey>ho</hey>";
        Marshaller marshaller = this.cacheFactory.getMarshaller();
        byte[] bytes = marshaller.objectToByteBuffer((Object)value);
        PutMethod put = new PutMethod(this.cacheFactory.getRestUrl() + "/" + "3");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(bytes, marshaller.mediaType().toString()));
        HttpClient restClient = this.cacheFactory.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        AssertJUnit.assertEquals((String)"", (String)put.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((Object)value, (Object)this.cacheFactory.getEmbeddedCache().get((Object)"3"));
        AssertJUnit.assertEquals((Object)value, (Object)this.cacheFactory.getMemcachedClient().get("3"));
        AssertJUnit.assertEquals((Object)value, (Object)this.cacheFactory.getHotRodCache().get((Object)"3"));
    }
}

