/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.function.BaseFunction;

public final class ContainsFunction<K, V>
implements BaseFunction<K, V, Boolean> {
    public static final AdvancedExternalizer<ContainsFunction> EXTERNALIZER = new Externalizer();
    private final V value;

    public ContainsFunction() {
        this.value = null;
    }

    public ContainsFunction(V value) {
        this.value = value;
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        Boolean contains = this.value == null ? Boolean.valueOf(entryView.find().isPresent()) : entryView.find().map(values -> values.contains(this.value)).orElse(Boolean.FALSE);
        return contains;
    }

    private static class Externalizer
    implements AdvancedExternalizer<ContainsFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends ContainsFunction>> getTypeClasses() {
            return Collections.singleton(ContainsFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.CONTAINS_KEY_VALUE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, ContainsFunction object) throws IOException {
            output.writeObject(object.value);
        }

        public ContainsFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ContainsFunction(input.readObject());
        }
    }
}

