/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5300)
public class Bucket<V> {
    final Collection<V> values;

    public Bucket() {
        this.values = ConcurrentHashMap.newKeySet();
    }

    @ProtoFactory
    Bucket(HashSet<MarshallableUserObject<V>> wrappedValues) {
        this.values = wrappedValues.stream().map(MarshallableUserObject::get).collect(Collectors.toSet());
    }

    @ProtoField(number=1, collectionImplementation=HashSet.class)
    Set<MarshallableUserObject<V>> getWrappedValues() {
        return this.values.stream().map(MarshallableUserObject::new).collect(Collectors.toSet());
    }

    public boolean contains(V value) {
        return this.values.contains(value);
    }

    public boolean add(V value) {
        return this.values.add(value);
    }

    public boolean addAll(Bucket<V> bucket) {
        return this.values.addAll(bucket.values);
    }

    public boolean remove(V value) {
        return this.values.remove(value);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }

    public Set<V> toSet() {
        return new HashSet<V>(this.values);
    }
}

