/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.multimap.api.embedded.EmbeddedMultimapCacheManagerFactory;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.api.embedded.MultimapCacheManager;
import org.infinispan.multimap.impl.DistributedMultimapCacheTest;
import org.infinispan.remoting.transport.Address;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.StoreTypeMultimapCacheTest")
public class StoreTypeMultimapCacheTest
extends DistributedMultimapCacheTest {
    protected Map<Address, MultimapCache<String, String>> multimapCacheCluster = new HashMap<Address, MultimapCache<String, String>>();

    public StoreTypeMultimapCacheTest() {
        this.l1CacheEnabled = false;
        this.cacheMode = CacheMode.REPL_SYNC;
        this.transactional = false;
        this.fromOwner = true;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new StoreTypeMultimapCacheTest().storageType(StorageType.OFF_HEAP), new StoreTypeMultimapCacheTest().storageType(StorageType.OBJECT), new StoreTypeMultimapCacheTest().storageType(StorageType.BINARY)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        for (EmbeddedCacheManager cacheManager : this.cacheManagers) {
            MultimapCacheManager multimapCacheManager = EmbeddedMultimapCacheManagerFactory.from((EmbeddedCacheManager)cacheManager);
            this.multimapCacheCluster.put(cacheManager.getAddress(), (MultimapCache<String, String>)multimapCacheManager.get(this.cacheName));
        }
    }

    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder cacheCfg = super.buildConfiguration();
        cacheCfg.memory().storageType(this.storageType);
        return cacheCfg;
    }
}

