/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.impl.DelegatingUserMarshaller;
import org.infinispan.marshall.persistence.impl.PersistenceMarshallerImpl;
import org.infinispan.multimap.api.embedded.EmbeddedMultimapCacheManagerFactory;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.api.embedded.MultimapCacheManager;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.SuperPerson;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="multimap.MultimapStoreBucketTest")
public class MultimapStoreBucketTest
extends AbstractInfinispanTest {
    public void testMultimapWithJavaSerializationMarshaller() throws Exception {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.defaultCacheName("test");
        globalBuilder.serialization().marshaller((Marshaller)new JavaSerializationMarshaller()).allowList().addClass(SuperPerson.class.getName());
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)config);
        MultimapCacheManager multimapCacheManager = EmbeddedMultimapCacheManagerFactory.from((EmbeddedCacheManager)cm);
        MultimapCache multimapCache = multimapCacheManager.get("test");
        multimapCache.put((Object)"k1", (Object)new SuperPerson());
        PersistenceMarshallerImpl pm = TestingUtil.extractPersistenceMarshaller((EmbeddedCacheManager)cm);
        DelegatingUserMarshaller userMarshaller = (DelegatingUserMarshaller)pm.getUserMarshaller();
        AssertJUnit.assertTrue((boolean)(userMarshaller.getDelegate() instanceof JavaSerializationMarshaller));
        AssertJUnit.assertTrue((boolean)pm.getSerializationContext().canMarshall(Bucket.class));
        AssertJUnit.assertTrue((boolean)((Boolean)multimapCache.containsKey((Object)"k1").get(1L, TimeUnit.SECONDS)));
    }
}

